/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5StorageLayout;
import java.util.NoSuchElementException;

final class HDF5NaturalBlockMDParameters {
    private final int rank;
    private final long[] numberOfBlocks;
    private final int[] naturalBlockSize;
    private final int[] lastBlockSize;

    HDF5NaturalBlockMDParameters(HDF5DataSetInformation info) {
        this.rank = info.getRank();
        long[] dimensions = info.getDimensions();
        this.naturalBlockSize = info.getStorageLayout() == HDF5StorageLayout.CHUNKED ? info.tryGetChunkSizes() : MDAbstractArray.toInt(dimensions);
        this.numberOfBlocks = new long[this.rank];
        this.lastBlockSize = new int[this.rank];
        int i = 0;
        while (i < dimensions.length) {
            int sizeModNaturalBlockSize = (int)(dimensions[i] % (long)this.naturalBlockSize[i]);
            this.numberOfBlocks[i] = dimensions[i] / (long)this.naturalBlockSize[i] + (long)(sizeModNaturalBlockSize != 0 ? 1 : 0);
            this.lastBlockSize[i] = sizeModNaturalBlockSize != 0 ? sizeModNaturalBlockSize : this.naturalBlockSize[i];
            ++i;
        }
    }

    HDF5NaturalBlockMDIndex getNaturalBlockIndex() {
        return new HDF5NaturalBlockMDIndex();
    }

    final class HDF5NaturalBlockMDIndex {
        private long[] index;
        private long[] offset;
        private int[] blockSize;
        private boolean indexCalculated;

        HDF5NaturalBlockMDIndex() {
            this.index = new long[HDF5NaturalBlockMDParameters.this.rank];
            this.offset = new long[HDF5NaturalBlockMDParameters.this.rank];
            this.blockSize = (int[])HDF5NaturalBlockMDParameters.this.naturalBlockSize.clone();
            this.indexCalculated = true;
        }

        boolean hasNext() {
            if (this.indexCalculated) {
                return true;
            }
            int i = this.index.length - 1;
            while (i >= 0) {
                int n = i;
                this.index[n] = this.index[n] + 1L;
                if (this.index[i] < HDF5NaturalBlockMDParameters.this.numberOfBlocks[i]) {
                    int n2 = i;
                    this.offset[n2] = this.offset[n2] + (long)HDF5NaturalBlockMDParameters.this.naturalBlockSize[i];
                    if (this.index[i] == HDF5NaturalBlockMDParameters.this.numberOfBlocks[i] - 1L) {
                        this.blockSize[i] = HDF5NaturalBlockMDParameters.this.lastBlockSize[i];
                    }
                    this.indexCalculated = true;
                    break;
                }
                this.index[i] = 0L;
                this.offset[i] = 0L;
                this.blockSize[i] = HDF5NaturalBlockMDParameters.this.naturalBlockSize[i];
                --i;
            }
            return this.indexCalculated;
        }

        long[] computeOffsetAndSizeGetOffsetClone() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexCalculated = false;
            return (long[])this.offset.clone();
        }

        int[] getBlockSize() {
            return this.blockSize;
        }

        long[] getIndexClone() {
            return (long[])this.index.clone();
        }
    }
}

