/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.table;

import javax.swing.JComboBox;
import javax.swing.RowFilter;
import jhi.flapjack.gui.table.AbstractColumn;
import jhi.flapjack.gui.table.CellData;
import jhi.flapjack.gui.table.LineDataTableModel;
import scri.commons.gui.RB;

public class FilterColumn
extends AbstractColumn {
    public static final int NONE = 0;
    private static final int LESS_THAN = 1;
    private static final int LESS_THAN_EQ = 2;
    private static final int EQUAL = 3;
    private static final int GREATER_THAN_EQ = 4;
    private static final int GREATER_THAN = 5;
    private static final int NOT_EQUAL = 6;
    private static final int FALSE = 7;
    private static final int TRUE = 8;
    private int filter = 0;
    private boolean isBoolFilter;
    private String value;

    public FilterColumn() {
    }

    FilterColumn(int colIndex, Class colClass, String name, int filter) {
        super(colIndex, name);
        this.filter = filter;
        this.isBoolFilter = colClass == Boolean.class;
    }

    public int getFilter() {
        return this.filter;
    }

    public void setFilter(int filter) {
        this.filter = filter;
    }

    public boolean isBoolFilter() {
        return this.isBoolFilter;
    }

    public void setBoolFilter(boolean boolFilter) {
        this.isBoolFilter = boolFilter;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    static JComboBox<FilterColumn> numericalFilters() {
        JComboBox<FilterColumn> combo = new JComboBox<FilterColumn>();
        combo.addItem(new FilterColumn(0, Object.class, "", 0));
        combo.addItem(new FilterColumn(0, Object.class, "", 1));
        combo.addItem(new FilterColumn(0, Object.class, "", 2));
        combo.addItem(new FilterColumn(0, Object.class, "", 3));
        combo.addItem(new FilterColumn(0, Object.class, "", 4));
        combo.addItem(new FilterColumn(0, Object.class, "", 5));
        combo.addItem(new FilterColumn(0, Object.class, "", 6));
        return combo;
    }

    static JComboBox<FilterColumn> booleanFilters() {
        JComboBox<FilterColumn> combo = new JComboBox<FilterColumn>();
        combo.addItem(new FilterColumn(0, Object.class, "", 0));
        combo.addItem(new FilterColumn(0, Object.class, "", 7));
        combo.addItem(new FilterColumn(0, Object.class, "", 8));
        return combo;
    }

    public boolean disabled() {
        return this.filter == 0 || this.filter < 7 && this.value == null;
    }

    Double convert(Object object) {
        Object o = ((CellData)object).getData();
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return (double)((Integer)o);
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        return null;
    }

    RowFilter<LineDataTableModel, Object> createRowFilter() {
        if (!this.isBoolFilter) {
            final double value = Double.parseDouble(this.value);
            switch (this.filter) {
                case 1: {
                    return new RowFilter<LineDataTableModel, Object>(){

                        @Override
                        public boolean include(RowFilter.Entry<? extends LineDataTableModel, ? extends Object> entry) {
                            return FilterColumn.this.convert(entry.getValue(FilterColumn.this.colIndex)) < value || FilterColumn.this.noFilter(entry);
                        }
                    };
                }
                case 2: {
                    return new RowFilter<LineDataTableModel, Object>(){

                        @Override
                        public boolean include(RowFilter.Entry<? extends LineDataTableModel, ? extends Object> entry) {
                            return FilterColumn.this.convert(entry.getValue(FilterColumn.this.colIndex)) <= value || FilterColumn.this.noFilter(entry);
                        }
                    };
                }
                case 3: {
                    return new RowFilter<LineDataTableModel, Object>(){

                        @Override
                        public boolean include(RowFilter.Entry<? extends LineDataTableModel, ? extends Object> entry) {
                            return FilterColumn.this.convert(entry.getValue(FilterColumn.this.colIndex)) == value || FilterColumn.this.noFilter(entry);
                        }
                    };
                }
                case 4: {
                    return new RowFilter<LineDataTableModel, Object>(){

                        @Override
                        public boolean include(RowFilter.Entry<? extends LineDataTableModel, ? extends Object> entry) {
                            return FilterColumn.this.convert(entry.getValue(FilterColumn.this.colIndex)) >= value || FilterColumn.this.noFilter(entry);
                        }
                    };
                }
                case 5: {
                    return new RowFilter<LineDataTableModel, Object>(){

                        @Override
                        public boolean include(RowFilter.Entry<? extends LineDataTableModel, ? extends Object> entry) {
                            return FilterColumn.this.convert(entry.getValue(FilterColumn.this.colIndex)) > value || FilterColumn.this.noFilter(entry);
                        }
                    };
                }
                case 6: {
                    return new RowFilter<LineDataTableModel, Object>(){

                        @Override
                        public boolean include(RowFilter.Entry<? extends LineDataTableModel, ? extends Object> entry) {
                            return FilterColumn.this.convert(entry.getValue(FilterColumn.this.colIndex)) != value || FilterColumn.this.noFilter(entry);
                        }
                    };
                }
            }
        } else {
            if (this.filter == 7) {
                return RowFilter.regexFilter(Boolean.toString(false), this.colIndex);
            }
            return RowFilter.regexFilter(Boolean.toString(true), this.colIndex);
        }
        return null;
    }

    private boolean noFilter(RowFilter.Entry<? extends LineDataTableModel, ? extends Object> entry) {
        return ((CellData)entry.getValue(0)).getLineInfo().getResults().isSortToTop();
    }

    public boolean matches(Object oEntry) {
        if (!this.isBoolFilter) {
            double entry = Double.parseDouble(oEntry.toString());
            double value = Double.parseDouble(this.value);
            switch (this.filter) {
                case 1: {
                    return entry < value;
                }
                case 2: {
                    return entry <= value;
                }
                case 3: {
                    return entry == value;
                }
                case 4: {
                    return entry >= value;
                }
                case 5: {
                    return entry > value;
                }
                case 6: {
                    return entry != value;
                }
            }
        } else {
            if (this.filter == 7) {
                return (Boolean)oEntry == false;
            }
            return (Boolean)oEntry == true;
        }
        return false;
    }

    public String toString() {
        switch (this.filter) {
            case 1: {
                return RB.getString((String)"gui.table.FilterColumn.lessThan");
            }
            case 2: {
                return RB.getString((String)"gui.table.FilterColumn.lessThanEq");
            }
            case 3: {
                return RB.getString((String)"gui.table.FilterColumn.equal");
            }
            case 4: {
                return RB.getString((String)"gui.table.FilterColumn.greaterThanEq");
            }
            case 5: {
                return RB.getString((String)"gui.table.FilterColumn.greaterThan");
            }
            case 6: {
                return RB.getString((String)"gui.table.FilterColumn.notEqual");
            }
            case 7: {
                return RB.getString((String)"gui.table.FilterColumn.false");
            }
            case 8: {
                return RB.getString((String)"gui.table.FilterColumn.true");
            }
        }
        return "";
    }

    String toShortString() {
        switch (this.filter) {
            case 1: {
                return "<";
            }
            case 2: {
                return "<=";
            }
            case 3: {
                return "=";
            }
            case 4: {
                return ">=";
            }
            case 5: {
                return ">";
            }
            case 6: {
                return "<>";
            }
            case 7: {
                return "FALSE";
            }
            case 8: {
                return "TRUE";
            }
        }
        return "";
    }

    public FilterColumn cloneMe() {
        FilterColumn clone = new FilterColumn();
        clone.colIndex = this.colIndex;
        clone.name = this.name;
        clone.filter = this.filter;
        clone.isBoolFilter = this.isBoolFilter;
        clone.value = this.value;
        return clone;
    }
}

