/*
 * Decompiled with CFR 0.152.
 */
package jhi.gobii;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import jhi.gobii.Parent;

public class SampleEntry {
    private final String dnaRunName;
    private final String germplasmName;
    private final HashSet<Parent> parents;

    public SampleEntry(String dnaRunName, String germplasmName, HashSet<Parent> parents) {
        this.dnaRunName = dnaRunName;
        this.germplasmName = germplasmName;
        this.parents = parents;
    }

    boolean hasParentType(String type) {
        return this.parents.stream().anyMatch(p -> p.getType().equals(type));
    }

    Set<Parent> getParentsByType(String type) {
        if (this.hasParentType(type)) {
            return this.parents.stream().collect(Collectors.groupingBy(Parent::getType, Collectors.toSet())).get(type);
        }
        return new HashSet<Parent>();
    }

    public String getDnaRunName() {
        return this.dnaRunName;
    }

    public String getGermplasmName() {
        return this.germplasmName;
    }

    public HashSet<Parent> getParents() {
        return this.parents;
    }
}

