/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.binning;

import java.util.ArrayList;
import jhi.flapjack.io.binning.IBinner;

class StandardBinner
implements IBinner {
    private float min = 0.0f;
    private float max = 1.0f;
    private int numBins = 10;
    private float binSize;

    StandardBinner(int numBins) {
        this.numBins = numBins;
        this.binSize = (this.max - this.min) / (float)numBins;
    }

    @Override
    public int bin(float value) {
        int bin = (int)((value - this.min) / this.binSize);
        if (bin == this.numBins) {
            bin = this.numBins - 1;
        }
        return bin;
    }

    @Override
    public ArrayList<float[]> getBinSummary() {
        ArrayList<float[]> list = new ArrayList<float[]>();
        for (int i = 0; i < this.numBins; ++i) {
            float f1 = (float)i * this.binSize;
            float f2 = (float)i * this.binSize + this.binSize;
            list.add(new float[]{f1, f2});
        }
        return list;
    }
}

