/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.binning;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import jhi.flapjack.io.binning.StandardBinner;

public class MakeHistogram {
    private float min = 0.0f;
    private float max = 1.0f;
    private float binSize;
    private int numBins = 1000;
    private int[] histogram;
    private StandardBinner binner;
    private DecimalFormat df = new DecimalFormat("0.000000000000000");
    private String inputFile;
    private String outputFile;
    NumberFormat nf = NumberFormat.getInstance();
    private static List<String> output;

    public static void main(String[] args) throws Exception {
        long s = System.currentTimeMillis();
        MakeHistogram mh = new MakeHistogram(Integer.parseInt(args[2]), args[0], args[1]);
        mh.createHistogram();
        long e = System.currentTimeMillis();
        MakeHistogram.logMessage("Time: " + (e - s) + "ms");
    }

    public MakeHistogram(int numBins, String inputFile, String outputFile) {
        this.numBins = numBins;
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        output = new ArrayList<String>();
    }

    private void setupBinner(int numBins) {
        this.binner = new StandardBinner(numBins);
        this.histogram = new int[numBins];
        this.binSize = (this.max - this.min) / (float)numBins;
        MakeHistogram.logMessage(" binsize: " + this.df.format(this.binSize));
    }

    public List<String> createHistogram() throws Exception {
        this.setupBinner(this.numBins);
        MakeHistogram.logMessage("Writing binned data...");
        this.writeBinFile(this.inputFile, this.outputFile);
        this.outputStats();
        return output;
    }

    private int[] calculateHistogram(String inFile) throws Exception {
        String str;
        BufferedReader in = new BufferedReader(new FileReader(inFile));
        while ((str = in.readLine()) != null && str.startsWith("#")) {
        }
        while ((str = in.readLine()) != null && str.length() > 0) {
            String[] split = str.split("\t");
            for (int i = 1; i < split.length; ++i) {
                int bin;
                if (split[i].isEmpty()) continue;
                float value = this.nf.parse(split[i]).floatValue();
                int n = bin = this.binner.bin(value);
                this.histogram[n] = this.histogram[n] + 1;
            }
        }
        in.close();
        return this.histogram;
    }

    private void writeBinFile(String inFile, String outFile) throws Exception {
        this.calculateHistogram(inFile);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outFile)));
        out.println("position\tcount");
        for (int i = 0; i < this.histogram.length; ++i) {
            out.println(this.df.format((float)i * this.binSize) + "\t" + this.histogram[i]);
        }
        out.close();
    }

    private void outputStats() throws IOException {
        int total = 0;
        for (int i : this.histogram) {
            total += i;
        }
        int modeBin = this.getModeBin();
        int medianBin = this.getMedianBin(total);
        int meanBin = this.getMeanBin(total);
        MakeHistogram.logMessage("Mean\t" + this.getBinRangeString(meanBin));
        MakeHistogram.logMessage("Median\t" + this.getBinRangeString(medianBin));
        MakeHistogram.logMessage("Mode\t" + this.getBinRangeString(modeBin));
    }

    private int getMeanBin(int total) {
        int meanBin = 0;
        for (int i = 0; i < this.histogram.length; ++i) {
            meanBin += i * this.histogram[i];
        }
        return meanBin /= total;
    }

    private int getMedianBin(int total) {
        int middle = total / 2;
        int medianBin = 0;
        int i = 0;
        for (int runningTot = 0; i < this.histogram.length && runningTot < middle; runningTot += this.histogram[i]) {
            medianBin = i++;
        }
        return medianBin;
    }

    private int getModeBin() {
        int modeBin = 0;
        for (int i = 0; i < this.histogram.length; ++i) {
            if (this.histogram[i] <= modeBin) continue;
            modeBin = i;
        }
        return modeBin;
    }

    private String getBinRangeString(int bin) {
        this.df.setMaximumFractionDigits(3);
        return this.df.format((float)bin * this.binSize) + "-" + this.df.format((float)(bin + 1) * this.binSize);
    }

    private static void logMessage(String message) {
        System.out.println(message);
        output.add(message);
    }
}

