/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.QTL;
import scri.commons.gui.RB;
import scri.commons.gui.SimpleJob;

public class QTLExporter
extends SimpleJob {
    private NumberFormat nf = NumberFormat.getInstance();
    private DataSet dataSet;
    private File file;

    public QTLExporter(DataSet dataSet, File file) {
        this.dataSet = dataSet;
        this.file = file;
        this.nf.setMaximumFractionDigits(6);
    }

    public void runJob(int index) throws Exception {
        ArrayList<QTL> qtls = new ArrayList<QTL>();
        for (ChromosomeMap cMap : this.dataSet.getChromosomeMaps()) {
            for (QTL qtl : cMap.getQtls()) {
                qtls.add(qtl);
            }
        }
        this.maximum = qtls.size();
        if (this.maximum == 0) {
            return;
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(this.file));
        out.write("# fjFile = QTL");
        out.newLine();
        this.writeHeader(out, qtls);
        for (QTL qtl : qtls) {
            if (!this.okToRun()) break;
            out.write(qtl.getName());
            out.write("\t" + qtl.getChromosomeMap().getName());
            out.write("\t" + this.nf.format(qtl.getPosition()));
            out.write("\t" + this.nf.format(qtl.getMin()));
            out.write("\t" + this.nf.format(qtl.getMax()));
            out.write("\t" + qtl.getTrait());
            out.write("\t" + qtl.getExperiment());
            for (int i = 0; i < qtl.getValues().length; ++i) {
                out.write("\t" + qtl.getValues()[i]);
            }
            out.newLine();
            ++this.progress;
        }
        out.close();
    }

    private void writeHeader(BufferedWriter out, ArrayList<QTL> qtls) throws Exception {
        QTL qtl = qtls.get(0);
        out.write(RB.getString((String)"gui.traits.QTLTableModel.qtl"));
        out.write("\t" + RB.getString((String)"gui.traits.QTLTableModel.chromosome"));
        out.write("\t" + RB.getString((String)"gui.traits.QTLTableModel.position"));
        out.write("\t" + RB.getString((String)"gui.traits.QTLTableModel.min"));
        out.write("\t" + RB.getString((String)"gui.traits.QTLTableModel.max"));
        out.write("\t" + RB.getString((String)"gui.traits.QTLTableModel.trait"));
        out.write("\t" + RB.getString((String)"gui.traits.QTLTableModel.experiment"));
        for (int i = 0; i < qtl.getValues().length; ++i) {
            out.write("\t" + qtl.getVNames()[i]);
        }
        out.newLine();
    }
}

