/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GenotypePanel;

class RowCanvas
extends JPanel {
    private GenotypeCanvas canvas;
    private GenotypePanel gPanel;
    private int lineIndex = -1;
    private int markerIndex;
    private int markerCount;
    private int h = 15;

    RowCanvas(GenotypePanel gPanel, GenotypeCanvas canvas) {
        this.gPanel = gPanel;
        this.canvas = canvas;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.add(new Canvas2D());
    }

    void updateOverviewSelectionBox(int markerIndex, int markerCount) {
        this.markerIndex = markerIndex;
        this.markerCount = markerCount;
        this.repaint();
    }

    void setLineIndex(int lineIndex) {
        if (this.lineIndex != lineIndex && !this.canvas.locked) {
            this.lineIndex = lineIndex;
            this.repaint();
        }
    }

    private class Canvas2D
    extends JPanel {
        Canvas2D() {
            this.setPreferredSize(new Dimension(0, RowCanvas.this.h));
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g = (Graphics2D)graphics;
            int xOffset = ((RowCanvas)RowCanvas.this).gPanel.traitCanvas.getPanelWidth() + ((RowCanvas)RowCanvas.this).gPanel.listPanel.getPanelWidth() + 1;
            int width = ((RowCanvas)RowCanvas.this).canvas.pX2 - ((RowCanvas)RowCanvas.this).canvas.pX1 + 1;
            g.translate(xOffset, 0);
            g.setColor(Prefs.visColorBackground);
            g.fillRect(0, 0, width, RowCanvas.this.h);
            if (RowCanvas.this.lineIndex < 0 || RowCanvas.this.lineIndex >= ((RowCanvas)RowCanvas.this).canvas.view.lineCount()) {
                return;
            }
            float xScale = (float)((RowCanvas)RowCanvas.this).canvas.boxTotalX / (float)width;
            for (int x = 0; x < width; ++x) {
                int mrkIndex = (int)(xScale * (float)x);
                g.setColor(((RowCanvas)RowCanvas.this).canvas.cScheme.getColor(RowCanvas.this.lineIndex, mrkIndex));
                g.fillRect(x, 0, 1, RowCanvas.this.h);
            }
            xScale = (float)width / (float)((RowCanvas)RowCanvas.this).canvas.boxTotalX;
            float x1 = (float)RowCanvas.this.markerIndex * xScale;
            float x2 = x1 + (float)RowCanvas.this.markerCount * xScale;
            if (RowCanvas.this.markerCount > ((RowCanvas)RowCanvas.this).canvas.boxTotalX || x2 >= (float)width) {
                x2 = width - 1;
            }
            int cR = Prefs.visColorOverviewFill.getRed();
            int cG = Prefs.visColorOverviewFill.getGreen();
            int cB = Prefs.visColorOverviewFill.getBlue();
            g.setPaint(new Color(cR, cG, cB, 50));
            g.fillRect(Math.round(x1), 0, Math.round(x2 - x1), RowCanvas.this.h - 1);
            g.setColor(Prefs.visColorOverviewOutline);
            g.drawRect(Math.round(x1), 0, Math.round(x2 - x1), RowCanvas.this.h - 1);
        }
    }
}

