/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.traits;

import java.awt.Component;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.QTL;
import jhi.flapjack.gui.Actions;
import scri.commons.gui.RB;

class QTLTableModel
extends AbstractTableModel {
    ArrayList<QTL> qtls = new ArrayList();
    private String[] columnNames;
    boolean qtlOffMap = false;

    QTLTableModel(DataSet dataSet) {
        for (ChromosomeMap cMap : dataSet.getChromosomeMaps()) {
            for (QTL qtl : cMap.getQtls()) {
                this.qtls.add(qtl);
                if (qtl.isAllowed()) continue;
                this.qtlOffMap = true;
            }
        }
        this.setColumnNames();
    }

    void setColumnNames() {
        if (this.qtls.size() == 0) {
            this.columnNames = new String[0];
        } else {
            QTL qtl = this.qtls.get(0);
            this.columnNames = new String[8 + qtl.getValues().length];
            this.columnNames[0] = RB.getString((String)"gui.traits.QTLTableModel.qtl");
            this.columnNames[1] = RB.getString((String)"gui.traits.QTLTableModel.chromosome");
            this.columnNames[2] = RB.getString((String)"gui.traits.QTLTableModel.position");
            this.columnNames[3] = RB.getString((String)"gui.traits.QTLTableModel.min");
            this.columnNames[4] = RB.getString((String)"gui.traits.QTLTableModel.max");
            this.columnNames[5] = RB.getString((String)"gui.traits.QTLTableModel.trait");
            this.columnNames[6] = RB.getString((String)"gui.traits.QTLTableModel.experiment");
            this.columnNames[7] = RB.getString((String)"gui.traits.QTLTableModel.visible");
            for (int i = 0; i < qtl.getValues().length; ++i) {
                this.columnNames[8 + i] = qtl.getVNames()[i];
            }
        }
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.qtls.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        QTL qtl = this.qtls.get(row);
        switch (col) {
            case 0: {
                return qtl;
            }
            case 1: {
                return qtl.getChromosomeMap().getName();
            }
            case 2: {
                return qtl.getPosition();
            }
            case 3: {
                return qtl.getMin();
            }
            case 4: {
                return qtl.getMax();
            }
            case 5: {
                return qtl.getTrait();
            }
            case 6: {
                return qtl.getExperiment();
            }
            case 7: {
                return qtl.isVisible();
            }
        }
        return qtl.getValues()[col - 8];
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return QTL.class;
        }
        if (col >= 2 && col <= 4) {
            return Float.class;
        }
        if (col == 7) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 7 && this.qtls.get(row).isAllowed();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.qtls.get(row).setVisible((Boolean)value);
        this.fireTableCellUpdated(row, col);
        Actions.projectModified();
    }

    static class NumStrRenderer
    extends DefaultTableCellRenderer {
        private NumberFormat nf = NumberFormat.getInstance();

        NumStrRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            try {
                this.setText(this.nf.format(this.nf.parse(value.toString())));
                this.setHorizontalAlignment(4);
            }
            catch (ParseException e) {
                this.setHorizontalAlignment(2);
                this.setText(value.toString());
            }
            return this;
        }
    }
}

