/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.table.FilterColumn;
import jhi.flapjack.gui.table.FilterDialogTableModel;
import scri.commons.gui.RB;
import scri.commons.gui.SwingUtils;
import scri.commons.gui.matisse.DialogPanel;

public class FilterDialog
extends JDialog
implements ActionListener {
    private boolean isOK = false;
    private FilterDialogTableModel model;
    private JButton bCancel;
    private JButton bFilter;
    private JButton bHelp;
    private JButton bReset;
    private DialogPanel dialogPanel1;
    private JLabel infoLabel;
    private JScrollPane jScrollPane1;
    private JTable table;

    public static FilterDialog getFilterDialog(FilterColumn[] allCols, FilterColumn[] lastUsedCols) {
        FilterDialog dialog = new FilterDialog(allCols, lastUsedCols);
        dialog.infoLabel.setVisible(false);
        dialog.setVisible(true);
        return dialog;
    }

    public static FilterDialog getSelectDialog(FilterColumn[] allCols, FilterColumn[] lastUsedCols) {
        FilterDialog dialog = new FilterDialog(allCols, lastUsedCols);
        dialog.setTitle(RB.getString((String)"gui.table.FilterDialog.titleAS"));
        RB.setText((AbstractButton)dialog.bFilter, (String)"gui.table.FilterDialog.bFilterAS");
        dialog.model.setColumnName(1, RB.getString((String)"gui.table.FilterDialog.col2AS"));
        dialog.setVisible(true);
        return dialog;
    }

    private FilterDialog(FilterColumn[] allCols, FilterColumn[] lastUsedCols) {
        super(Flapjack.winMain, RB.getString((String)"gui.table.FilterDialog.title"), true);
        this.initComponents();
        this.initTable(allCols, lastUsedCols);
        RB.setText((AbstractButton)this.bCancel, (String)"gui.text.cancel");
        RB.setText((AbstractButton)this.bFilter, (String)"gui.table.FilterDialog.bFilter");
        RB.setText((AbstractButton)this.bReset, (String)"gui.table.FilterDialog.bReset");
        RB.setText((AbstractButton)this.bHelp, (String)"gui.text.help");
        FlapjackUtils.setHelp(this.bHelp, "analysis_results_tables.html#filtering-lines");
        this.getContentPane().setBackground((Color)UIManager.get("fjDialogBG"));
        this.bFilter.addActionListener(this);
        this.bReset.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.getRootPane().setDefaultButton(this.bFilter);
        SwingUtils.addCloseHandler((Window)this, (JComponent)this.bCancel);
        this.pack();
        this.setLocationRelativeTo(Flapjack.winMain);
        this.setResizable(false);
    }

    public void setUsageAndDisplay(boolean isAutoSelect) {
        this.setTitle(RB.getString((String)"gui.table.FilterDialog.titleAS"));
        this.setVisible(true);
    }

    private JTable createTable() {
        return new JTable(){

            @Override
            public TableCellEditor getCellEditor(int row, int column) {
                int modelColumn = this.convertColumnIndexToModel(column);
                if (modelColumn == 1) {
                    if (FilterDialog.this.model.needsBooleanFilter(row)) {
                        return new DefaultCellEditor(FilterColumn.booleanFilters());
                    }
                    return new DefaultCellEditor(FilterColumn.numericalFilters());
                }
                DefaultCellEditor editor = (DefaultCellEditor)super.getCellEditor(row, column);
                editor.setClickCountToStart(1);
                return editor;
            }
        };
    }

    private void initTable(FilterColumn[] allCols, FilterColumn[] lastUsedCols) {
        this.model = new FilterDialogTableModel(allCols, lastUsedCols);
        this.table.setModel(this.model);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bFilter) {
            this.isOK = true;
            this.setVisible(false);
        } else if (e.getSource() == this.bReset) {
            this.model.clear();
        } else if (e.getSource() == this.bCancel) {
            this.setVisible(false);
        }
    }

    public FilterColumn[] getResults() {
        FilterColumn[] results = this.model.getResults();
        FilterColumn[] clone = new FilterColumn[results.length];
        for (int i = 0; i < clone.length; ++i) {
            clone[i] = results[i].cloneMe();
        }
        return clone;
    }

    public boolean isOK() {
        return this.isOK;
    }

    private void initComponents() {
        this.dialogPanel1 = new DialogPanel();
        this.bFilter = new JButton();
        this.bReset = new JButton();
        this.bCancel = new JButton();
        this.bHelp = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.table = this.createTable();
        this.infoLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.bFilter.setText("Filter");
        this.dialogPanel1.add((Component)this.bFilter);
        this.bReset.setText("Reset");
        this.dialogPanel1.add((Component)this.bReset);
        this.bCancel.setText("Cancel");
        this.dialogPanel1.add((Component)this.bCancel);
        this.bHelp.setText("Help");
        this.dialogPanel1.add((Component)this.bHelp);
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.table.setAutoResizeMode(4);
        this.jScrollPane1.setViewportView(this.table);
        this.infoLabel.setText("Note that selection criteria will only apply to lines that are currently visible in the results table.");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dialogPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 480, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.infoLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 183, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dialogPanel1, -2, 46, -2)));
        this.pack();
    }
}

