/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.navpanel;

import javax.swing.JPanel;
import jhi.flapjack.data.Bookmark;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.navpanel.VisualizationChildNode;
import jhi.flapjack.gui.navpanel.VisualizationNode;
import jhi.flapjack.gui.visualization.BookmarkHighlighter;
import jhi.flapjack.gui.visualization.GenotypePanel;

public class BookmarkNode
extends VisualizationChildNode {
    private GenotypePanel gPanel;
    private VisualizationNode parent;
    private Bookmark bookmark;
    private GTViewSet viewSet;

    public BookmarkNode(GenotypePanel gPanel, VisualizationNode parent, Bookmark bookmark) {
        super(gPanel, parent.getViewSet(), bookmark.getChromosome().getName() + ": " + bookmark.getLine().getName() + " / " + bookmark.getMarker().getName());
        this.gPanel = gPanel;
        this.parent = parent;
        this.bookmark = bookmark;
        this.viewSet = parent.getViewSet();
    }

    public Bookmark getBookmark() {
        return this.bookmark;
    }

    @Override
    public GTViewSet getViewSet() {
        return this.parent.getViewSet();
    }

    @Override
    public void setActions() {
        this.parent.setActions();
        Actions.viewRenameView.setEnabled(false);
        Actions.viewDeleteView.setEnabled(false);
        Actions.viewDeleteBookmark.setEnabled(true);
    }

    @Override
    public JPanel getPanel() {
        this.mapViewSet();
        int index = this.viewSet.indexof(this.viewSet.getView(this.bookmark.getChromosome()));
        this.viewSet.setViewIndex(index);
        GTView view = this.viewSet.getView(index);
        int lineIndex = this.viewSet.indexOf(this.bookmark.getLine());
        int mrkrIndex = view.indexOf(this.bookmark.getMarker());
        new BookmarkHighlighter(this.gPanel, view, lineIndex, mrkrIndex);
        return this.parent.getPanel();
    }
}

