/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.importer;

import java.awt.Color;
import java.awt.Frame;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import jhi.brapi.api.studies.BrapiStudies;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.dialog.importer.BrapiImportDialog;
import jhi.flapjack.gui.dialog.importer.IBrapiWizard;
import jhi.flapjack.io.brapi.BrapiClient;
import scri.commons.gui.ITrackableJob;
import scri.commons.gui.ProgressDialog;
import scri.commons.gui.RB;
import scri.commons.gui.SimpleJob;

class BrapiStudiesPanelNB
extends JPanel
implements IBrapiWizard {
    private BrapiClient client;
    private List<BrapiStudies> studies;
    private BrapiImportDialog dialog;
    private DefaultComboBoxModel<String> studiesModel;
    private JLabel detailsLabel;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JLabel mapsLabel;
    private JComboBox<String> studiesCombo;
    private JTextArea text;

    public BrapiStudiesPanelNB(BrapiClient client, BrapiImportDialog dialog) {
        this.client = client;
        this.dialog = dialog;
        this.initComponents();
        this.studiesCombo.addActionListener(e -> this.displayStudies());
    }

    private void displayStudies() {
        int index = this.studiesCombo.getSelectedIndex();
        if (index >= 0) {
            BrapiStudies study = this.studies.get(index);
            this.client.setStudyID(study.getStudyDbId());
            this.text.setText(study.getName() + " - " + study.getStudyDbId());
        } else {
            this.text.setText("");
        }
        this.dialog.enableNext(index >= 0);
    }

    private void refreshStudies() {
        ProgressDialog pd = new ProgressDialog((ITrackableJob)new DataDownloader(), RB.getString((String)"gui.dialog.importer.BrapiStudiesPanelNB.title"), RB.getString((String)"gui.dialog.importer.BrapiStudiesPanelNB.message"), (Frame)Flapjack.winMain);
        if (pd.failed("gui.error")) {
            return;
        }
        this.studiesModel = new DefaultComboBoxModel();
        for (BrapiStudies study : this.studies) {
            this.studiesModel.addElement(study.getStudyDbId() + " - " + study.getName());
        }
        this.studiesCombo.setModel(this.studiesModel);
        this.displayStudies();
        this.dialog.enableNext(this.studiesModel.getSize() > 0);
    }

    @Override
    public void onShow() {
        this.dialog.enableBack(true);
        this.dialog.enableNext(this.studiesModel != null && this.studiesModel.getSize() > 0);
        if (this.studiesModel == null || this.studiesModel.getSize() == 0) {
            this.refreshStudies();
        }
    }

    @Override
    public void onNext() {
        if (Prefs.guiBrAPIUseMaps) {
            this.dialog.setScreen(this.dialog.getMapsPanel());
        } else if (this.client.hasAlleleMatrices()) {
            this.dialog.setScreen(this.dialog.getMatricesPanel());
        } else {
            this.dialog.wizardCompleted();
        }
        this.dialog.getBNext().requestFocusInWindow();
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public String getCardName() {
        return "studies";
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.mapsLabel = new JLabel();
        this.studiesCombo = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.text = new JTextArea();
        this.detailsLabel = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Study selection:"));
        this.mapsLabel.setLabelFor(this.studiesCombo);
        this.mapsLabel.setText("Available studies:");
        this.text.setEditable(false);
        this.text.setColumns(20);
        this.text.setRows(5);
        this.jScrollPane1.setViewportView(this.text);
        this.detailsLabel.setText("Details:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.mapsLabel).addGap(11, 11, 11).addComponent(this.studiesCombo, 0, -1, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.detailsLabel).addGap(0, 405, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mapsLabel).addComponent(this.studiesCombo, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.detailsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 153, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private class DataDownloader
    extends SimpleJob {
        private DataDownloader() {
        }

        public void runJob(int jobID) throws Exception {
            if (BrapiStudiesPanelNB.this.client.hasStudiesSearchGET()) {
                BrapiStudiesPanelNB.this.studies = BrapiStudiesPanelNB.this.client.getStudies();
            } else {
                BrapiStudiesPanelNB.this.studies = BrapiStudiesPanelNB.this.client.getStudiesByPost();
            }
        }
    }
}

