/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.data;

import java.util.LinkedList;
import jhi.flapjack.data.IUndoState;

public class UndoManager {
    private LinkedList<IUndoState> stack = new LinkedList();
    private int stackPointer = -1;

    UndoManager() {
    }

    LinkedList<IUndoState> getStack() {
        return this.stack;
    }

    int getStackPointer() {
        return this.stackPointer;
    }

    public void addUndoState(IUndoState state) {
        for (int i = this.stack.size() - 1; i > this.stackPointer; --i) {
            this.stack.remove(i);
        }
        this.stack.add(state);
        ++this.stackPointer;
    }

    public boolean canUndo() {
        return this.stackPointer >= 0;
    }

    public String getNextUndoString() {
        if (this.canUndo()) {
            return this.stack.get(this.stackPointer).getMenuString();
        }
        return "";
    }

    public IUndoState processUndo(IUndoState state) {
        if (state == null) {
            state = this.stack.get(this.stackPointer);
            state.applyUndoState();
            --this.stackPointer;
        } else {
            state.applyUndoState();
        }
        return state;
    }

    public boolean canRedo() {
        return this.stack.size() > 0 && this.stackPointer < this.stack.size() - 1;
    }

    public String getNextRedoString() {
        if (this.canRedo()) {
            return this.stack.get(this.stackPointer + 1).getMenuString();
        }
        return "";
    }

    public IUndoState processRedo() {
        ++this.stackPointer;
        IUndoState state = this.stack.get(this.stackPointer);
        state.applyRedoState();
        return state;
    }
}

