/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import java.util.ArrayList;
import jhi.flapjack.analysis.AnalysisSet;
import jhi.flapjack.data.GTViewSet;
import scri.commons.gui.SimpleJob;

public class DataSummary
extends SimpleJob {
    private GTViewSet viewSet;
    private ArrayList<long[]> results;
    private long alleleCount;
    private double prg;

    public DataSummary(GTViewSet viewSet) {
        this.viewSet = viewSet;
    }

    public long getAlleleCount() {
        return this.alleleCount;
    }

    public ArrayList<long[]> getResults() {
        return this.results;
    }

    public void runJob(int index) throws Exception {
        AnalysisSet as = new AnalysisSet(this.viewSet).withViews(null).withAllLines().withAllMarkers();
        this.alleleCount = as.countAlleles();
        this.maximum = 50000;
        this.results = new ArrayList();
        for (int i = 0; i < as.viewCount(); ++i) {
            this.results.add(this.getStatistics(as, i));
        }
    }

    private long[] getStatistics(AnalysisSet as, int chrIndex) {
        int stateCount = this.viewSet.getDataSet().getStateTable().size();
        long[] statistics = new long[stateCount + 1];
        for (int line = 0; line < as.lineCount() && this.okToRun; ++line) {
            for (int marker = 0; marker < as.markerCount(chrIndex) && this.okToRun; ++marker) {
                int state;
                int n = state = as.getState(chrIndex, line, marker);
                statistics[n] = statistics[n] + 1L;
                int n2 = statistics.length - 1;
                statistics[n2] = statistics[n2] + 1L;
                this.prg += 1.0;
                this.progress = (int)(this.prg / (double)this.alleleCount * 50000.0);
            }
        }
        return statistics;
    }
}

