/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.mapping.ExtendedFieldHandler;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.MarshalFramework;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.UnmarshalHandler;
import org.exolab.castor.xml.UnmarshalState;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.util.ContainerElement;
import org.exolab.castor.xml.util.XMLClassDescriptorImpl;
import org.xml.sax.SAXException;

public class StartElementProcessor {
    private static final Log LOG = LogFactory.getLog(StartElementProcessor.class);
    protected static ResourceBundle resourceBundle = ResourceBundle.getBundle("UnmarshalHandlerMessages", Locale.getDefault());
    private final UnmarshalHandler _unmarshalHandler;

    public StartElementProcessor(UnmarshalHandler unmarshalHandler) {
        this._unmarshalHandler = unmarshalHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compute(String name, String namespace, AttributeSet atts) throws SAXException {
        XMLClassDescriptor cdInherited;
        XMLFieldDescriptor descriptor;
        XMLClassDescriptor classDesc;
        Class cls;
        UnmarshalState parentState;
        UnmarshalState state;
        block89: {
            Object containerObject;
            block92: {
                block90: {
                    FieldHandler handler;
                    Object object;
                    block91: {
                        state = null;
                        String xmlSpace = null;
                        if (atts != null && (xmlSpace = atts.getValue("space", "http://www.w3.org/XML/1998/namespace")) == null) {
                            xmlSpace = atts.getValue("xml:space", "");
                        }
                        if (this._unmarshalHandler.getStateStack().isEmpty()) {
                            this._unmarshalHandler.processFirstElement(name, namespace, atts, xmlSpace);
                            return;
                        }
                        parentState = this._unmarshalHandler.getStateStack().getLastState();
                        boolean canAccept = false;
                        while (parentState.getFieldDescriptor() != null && parentState.getFieldDescriptor().isContainer() && !canAccept) {
                            XMLClassDescriptor tempClassDesc = parentState.getClassDescriptor();
                            if (tempClassDesc == null && (tempClassDesc = (XMLClassDescriptor)parentState.getFieldDescriptor().getClassDescriptor()) == null) {
                                tempClassDesc = this._unmarshalHandler.getClassDescriptor(parentState.getObject().getClass());
                            }
                            if (!(canAccept = tempClassDesc.canAccept(name, namespace, parentState.getObject()))) {
                                if (tempClassDesc.getFieldDescriptor(name, namespace, NodeType.Element) != null && !parentState.getFieldDescriptor().isMultivalued()) {
                                    String error = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.container.full"), tempClassDesc.getJavaClass().getName(), name);
                                    ValidationException vx = new ValidationException(error);
                                    throw new SAXException((Exception)((Object)vx));
                                }
                                this._unmarshalHandler.endElement(parentState.getElementName());
                                parentState = this._unmarshalHandler.getStateStack().getLastState();
                            }
                            tempClassDesc = null;
                        }
                        state = new UnmarshalState();
                        state.setElementName(name);
                        state.setParent(parentState);
                        if (xmlSpace != null) {
                            state.setWhitespacePreserving("preserve".equals(xmlSpace));
                        } else {
                            state.setWhitespacePreserving(parentState.isWhitespacePreserving());
                        }
                        this._unmarshalHandler.getStateStack().pushState(state);
                        if (parentState.getObject() == null && !parentState.isWrapper()) {
                            return;
                        }
                        cls = null;
                        classDesc = parentState.getClassDescriptor();
                        if (classDesc == null && (classDesc = (XMLClassDescriptor)parentState.getFieldDescriptor().getClassDescriptor()) == null) {
                            classDesc = this._unmarshalHandler.getClassDescriptor(parentState.getObject().getClass());
                        }
                        descriptor = null;
                        cdInherited = null;
                        UnmarshalState targetState = parentState;
                        String path = "";
                        int count = 0;
                        boolean isWrapper = false;
                        XMLClassDescriptor oldClassDesc = classDesc;
                        while (descriptor == null) {
                            MarshalFramework.InheritanceMatch match;
                            MarshalFramework.InheritanceMatch[] matches;
                            block87: {
                                block88: {
                                    block85: {
                                        block86: {
                                            if (path.length() > 0) {
                                                String tmpName = path + "/" + name;
                                                descriptor = classDesc.getFieldDescriptor(tmpName, namespace, NodeType.Element);
                                            }
                                            if (descriptor == null) {
                                                descriptor = classDesc.getFieldDescriptor(name, namespace, NodeType.Element);
                                            }
                                            if (!(descriptor == null || descriptor.isContainer() || !StringUtils.isNotEmpty((CharSequence)namespace) || MarshalFramework.namespaceEquals(namespace, descriptor.getNameSpaceURI()) || descriptor.getNameSpaceURI() == null && descriptor.matches("*"))) {
                                                descriptor = null;
                                            }
                                            if (descriptor != null || targetState.isWrapper()) break block85;
                                            matches = null;
                                            try {
                                                matches = this._unmarshalHandler.searchInheritance(name, namespace, classDesc);
                                            }
                                            catch (MarshalException marshalException) {
                                                // empty catch block
                                            }
                                            if (matches.length == 0) break block86;
                                            match = null;
                                            break block87;
                                        }
                                        StringBuilder tmpLocation = new StringBuilder();
                                        if (count > 0) {
                                            tmpLocation.append(path).append('/');
                                        }
                                        tmpLocation.append(name);
                                        isWrapper = isWrapper || MarshalFramework.hasFieldsAtLocation(tmpLocation.toString(), classDesc);
                                        break block88;
                                    }
                                    if (descriptor != null) {
                                        String tmpPath = descriptor.getLocationPath();
                                        if (path.equals(StringUtils.defaultString((String)tmpPath))) break;
                                        descriptor = null;
                                    } else {
                                        boolean bl = isWrapper = isWrapper || MarshalFramework.hasFieldsAtLocation(path + '/' + name, classDesc);
                                    }
                                }
                                if (targetState == this._unmarshalHandler.getTopState()) break;
                                path = count == 0 ? targetState.getElementName() : targetState.getElementName() + '/' + path;
                                targetState = targetState.getParent();
                                classDesc = targetState.getClassDescriptor();
                                ++count;
                                continue;
                            }
                            for (int i = 0; i < matches.length; ++i) {
                                if (!parentState.getElementName().equals(matches[i].parentFieldDesc.getLocationPath())) continue;
                                match = matches[i];
                                break;
                            }
                            if (match == null) {
                                match = matches[0];
                            }
                            descriptor = match.parentFieldDesc;
                            cdInherited = match.inheritedClassDesc;
                            break;
                        }
                        if (descriptor != null && this._unmarshalHandler.isValidating() && !this._unmarshalHandler.getInternalContext().getLenientSequenceOrder()) {
                            try {
                                classDesc.checkDescriptorForCorrectOrderWithinSequence(descriptor, parentState, name);
                            }
                            catch (ValidationException e) {
                                throw new SAXException((Exception)((Object)e));
                            }
                        }
                        if (descriptor == null) {
                            classDesc = oldClassDesc;
                            if (isWrapper) {
                                state.setClassDescriptor(new XMLClassDescriptorImpl(ContainerElement.class, name));
                                state.setWrapper(true);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("wrapper-element: " + name));
                                }
                                this._unmarshalHandler.processWrapperAttributes(atts);
                                return;
                            }
                            String error = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.find.field.descriptor"), name, classDesc.getXMLName());
                            if (classDesc instanceof MarshalFramework.InternalXMLClassDescriptor) {
                                classDesc = ((MarshalFramework.InternalXMLClassDescriptor)classDesc).getClassDescriptor();
                            }
                            boolean lenientElementStrictnessForIntrospection = this._unmarshalHandler.getInternalContext().getBooleanProperty("org.exolab.castor.xml.lenient.introspected.element.strictness");
                            if (this._unmarshalHandler.getStrictElementHandler().skipStartElementIgnoringDepth()) {
                                this._unmarshalHandler.getStateStack().removeLastState();
                                this._unmarshalHandler.getNamespaceHandling().removeCurrentNamespaceInstance();
                                if (!LOG.isDebugEnabled()) return;
                                String debug = MessageFormat.format(resourceBundle.getString("unmarshalHandler.log.debug.ignore.extra.element"), error);
                                LOG.debug((Object)debug);
                                return;
                            }
                            if (!lenientElementStrictnessForIntrospection) throw new SAXException(error);
                            if (!Introspector.introspected(classDesc)) throw new SAXException(error);
                            LOG.warn((Object)error);
                            return;
                        }
                        if (targetState != parentState) {
                            state.setTargetState(targetState);
                            parentState = targetState;
                        }
                        object = parentState.getObject();
                        if (!descriptor.isContainer()) break block89;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("#container: " + descriptor.getFieldName()));
                        }
                        state.clear();
                        state.setWhitespacePreserving(parentState.isWhitespacePreserving());
                        state.setParent(parentState);
                        state.setElementName(descriptor.getFieldName());
                        state.setFieldDescriptor(descriptor);
                        state.setClassDescriptor((XMLClassDescriptor)descriptor.getClassDescriptor());
                        containerObject = null;
                        if (descriptor.isMultivalued()) break block90;
                        handler = descriptor.getHandler();
                        containerObject = handler.getValue(object);
                        if (containerObject == null) break block91;
                        if (state.getClassDescriptor() != null) {
                            if (state.getClassDescriptor().canAccept(name, namespace, containerObject)) {
                                parentState.markAsNotUsed(descriptor);
                            }
                            break block92;
                        } else {
                            parentState.markAsNotUsed(descriptor);
                        }
                        break block92;
                    }
                    containerObject = handler.newInstance(object);
                    break block92;
                }
                Class containerClass = descriptor.getFieldType();
                try {
                    containerObject = containerClass.newInstance();
                }
                catch (Exception ex) {
                    throw new SAXException(ex);
                }
            }
            state.setObject(containerObject);
            state.setType(containerObject.getClass());
            this._unmarshalHandler.getNamespaceHandling().createNamespace();
            this._unmarshalHandler.startElementProcessing(name, namespace, atts);
            return;
        }
        state.setFieldDescriptor(descriptor);
        classDesc = null;
        if (cdInherited != null) {
            classDesc = cdInherited;
        } else if (!name.equals(descriptor.getXMLName())) {
            classDesc = this._unmarshalHandler.resolveByXMLName(name, namespace, null);
        }
        if (classDesc == null) {
            classDesc = (XMLClassDescriptor)descriptor.getClassDescriptor();
        }
        FieldHandler handler = descriptor.getHandler();
        boolean useHandler = true;
        try {
            block84: {
                block93: {
                    String currentPackage;
                    String instanceType;
                    if (classDesc != null) {
                        cls = classDesc.getJavaClass();
                        if (descriptor.getFieldType() != cls) {
                            state.setDerived(true);
                        }
                    } else {
                        cls = descriptor.getFieldType();
                    }
                    if (cls == null) {
                        cls = Object.class;
                    }
                    if ((instanceType = this._unmarshalHandler.getInstanceType(atts, currentPackage = this._unmarshalHandler.getJavaPackage(parentState.getType()))) != null) {
                        Class<?> instanceClass = null;
                        try {
                            XMLClassDescriptor instanceDesc = this._unmarshalHandler.getClassDescriptor(instanceType, this._unmarshalHandler.getClassLoader());
                            boolean loadClass = true;
                            if (instanceDesc != null) {
                                instanceClass = instanceDesc.getJavaClass();
                                classDesc = instanceDesc;
                                if (instanceClass != null) {
                                    boolean bl = loadClass = !instanceClass.getName().equals(instanceType);
                                }
                            }
                            if (loadClass) {
                                instanceClass = this._unmarshalHandler.loadClass(instanceType, null);
                                FieldHandler tempHandler = descriptor.getHandler();
                                boolean collection = false;
                                collection = tempHandler instanceof FieldHandlerImpl ? ((FieldHandlerImpl)tempHandler).isCollection() : Introspector.isCollection(instanceClass);
                                if (!(collection || cls.isAssignableFrom(instanceClass) || MarshalFramework.isPrimitive(cls))) {
                                    String err = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.not.subclass"), instanceClass.getName(), cls.getName());
                                    throw new SAXException(err);
                                }
                            }
                            cls = instanceClass;
                            useHandler = false;
                        }
                        catch (Exception ex) {
                            String err = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.unable.instantiate.exception"), instanceType, ex.getMessage());
                            throw new SAXException(err, ex);
                        }
                    }
                    if (cls == Object.class && parentState.getObject() instanceof UnmarshalHandler.ArrayHandler) {
                        cls = ((UnmarshalHandler.ArrayHandler)parentState.getObject()).componentType();
                    }
                    if (cls == Object.class) {
                        String pkg;
                        int idx;
                        Class<?> pClass = parentState.getType();
                        ClassLoader loader = pClass.getClassLoader();
                        classDesc = this._unmarshalHandler.resolveByXMLName(name, namespace, loader);
                        String cname = null;
                        if (classDesc == null) {
                            cname = this._unmarshalHandler.getJavaNaming().toJavaClassName(name);
                            classDesc = this._unmarshalHandler.getClassDescriptor(cname, loader);
                        }
                        if (classDesc == null && (idx = (pkg = pClass.getName()).lastIndexOf(46)) > 0) {
                            pkg = pkg.substring(0, idx + 1);
                            cname = pkg + cname;
                            classDesc = this._unmarshalHandler.getClassDescriptor(cname, loader);
                        }
                        if (classDesc == null) {
                            state.setObject(this._unmarshalHandler.getAnyNodeHandler().commonStartElement(name, namespace, state.isWhitespacePreserving()));
                            state.setType(cls);
                            return;
                        }
                        cls = classDesc.getJavaClass();
                        useHandler = false;
                    }
                    boolean byteArray = false;
                    if (cls.isArray()) {
                        boolean bl = byteArray = cls.getComponentType() == Byte.TYPE;
                    }
                    if (!MarshalFramework.isPrimitive(cls) && !descriptor.isImmutable() && !byteArray) break block93;
                    state.setObject(null);
                    state.setPrimitiveOrImmutable(true);
                    if (descriptor.isImmutable()) {
                        if (classDesc == null) {
                            classDesc = this._unmarshalHandler.getClassDescriptor(cls);
                        }
                        state.setClassDescriptor(classDesc);
                        UnmarshalHandler.Arguments args = this._unmarshalHandler.processConstructorArgs(atts, classDesc);
                        if (args != null && args.size() > 0) {
                            state.setConstructorArguments(args);
                        }
                    }
                    break block84;
                }
                if (classDesc == null) {
                    classDesc = this._unmarshalHandler.getClassDescriptor(cls);
                }
                if (!state.isDerived() && useHandler) {
                    boolean create = true;
                    if (this._unmarshalHandler.isReuseObjects()) {
                        state.setObject(handler.getValue(parentState.getObject()));
                        boolean bl = create = state.getObject() == null;
                    }
                    if (create) {
                        UnmarshalHandler.Arguments args = this._unmarshalHandler.processConstructorArgs(atts, classDesc);
                        if (args.getValues() != null && args.getValues().length > 0) {
                            if (!(handler instanceof ExtendedFieldHandler)) {
                                String err = resourceBundle.getString("unmarshalHandler.error.constructor.arguments");
                                throw new SAXException(err);
                            }
                            ExtendedFieldHandler efh = (ExtendedFieldHandler)handler;
                            state.setObject(efh.newInstance(parentState.getObject(), args.getValues()));
                        } else {
                            state.setObject(handler.newInstance(parentState.getObject()));
                        }
                    }
                }
                if (state.getObject() != null) {
                    cls = state.getObject().getClass();
                    if (classDesc != null && classDesc.getJavaClass() != cls) {
                        classDesc = null;
                    }
                } else {
                    try {
                        if (cls.isArray()) {
                            state.setObject(new UnmarshalHandler.ArrayHandler(cls.getComponentType()));
                            cls = UnmarshalHandler.ArrayHandler.class;
                        } else {
                            UnmarshalHandler.Arguments args = this._unmarshalHandler.processConstructorArgs(atts, classDesc);
                            state.setObject(this._unmarshalHandler.createInstance(cls, args));
                        }
                    }
                    catch (Exception ex) {
                        String err = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.unable.instantiate.exception"), this._unmarshalHandler.className(cls), ex.getMessage());
                        throw new SAXException(err, ex);
                    }
                }
            }
            state.setType(cls);
        }
        catch (IllegalStateException ise) {
            LOG.error((Object)ise.toString());
            throw new SAXException(ise);
        }
        if (classDesc == null) {
            classDesc = this._unmarshalHandler.getClassDescriptor(cls);
        }
        state.setClassDescriptor(classDesc);
        if (state.getObject() == null && !state.isPrimitiveOrImmutable()) {
            String err = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.unable.unmarshal"), name, this._unmarshalHandler.className(cls));
            throw new SAXException(err);
        }
        if (descriptor.isIncremental()) {
            if (LOG.isDebugEnabled()) {
                String debug = MessageFormat.format(resourceBundle.getString("unmarshalHandler.log.debug.process.incrementally"), name);
                LOG.debug((Object)debug);
            }
            try {
                handler.setValue(parentState.getObject(), state.getObject());
            }
            catch (IllegalStateException ise) {
                String err = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.unable.add.element"), name, parentState.getFieldDescriptor().getXMLName(), ise.getMessage());
                throw new SAXException(err, ise);
            }
        }
        if (state.getObject() != null) {
            Object stateObject = state.getObject();
            Object parentObject = state.getParent() == null ? null : state.getParent().getObject();
            this._unmarshalHandler.getDelegateUnmarshalListener().initialized(stateObject, parentObject);
            this._unmarshalHandler.processAttributes(atts, classDesc);
            this._unmarshalHandler.getDelegateUnmarshalListener().attributesProcessed(stateObject, parentObject);
            this._unmarshalHandler.getNamespaceHandling().processNamespaces(classDesc, this._unmarshalHandler.getStateStack().getLastState().getObject());
            return;
        }
        if (state.getType() != null && !state.isPrimitiveOrImmutable()) {
            if (atts == null) return;
            this._unmarshalHandler.processWrapperAttributes(atts);
            String warn = MessageFormat.format(resourceBundle.getString("unmarshalHandler.log.warn.process.attribute.as.location"), name);
            LOG.warn((Object)warn);
            return;
        }
        if (atts == null) return;
        String nil = atts.getValue("nil", "http://www.w3.org/2001/XMLSchema-instance");
        state.setNil("true".equals(nil));
        this._unmarshalHandler.processWrapperAttributes(atts);
    }
}

