/*
 * Decompiled with CFR 0.152.
 */
package scri.commons.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import scri.commons.gui.SwingUtils;
import scri.commons.gui.matisse.DialogPanel;

public class TaskDialog
extends JDialog {
    public static final int ERR = 0;
    public static final int WAR = 2;
    public static final int INF = 1;
    public static final int PLN = -1;
    public static final int QST = 3;
    private static String TITLE;
    private static JFrame PARENT;
    private static boolean isHeadless;
    private static File LOGFILE;
    private static String VIEWLOG;
    private static String CLOSE;
    private int selectedOption = -1;

    public static void initialize(JFrame parentFrame, String dialogTitle) {
        PARENT = parentFrame;
        TITLE = dialogTitle;
    }

    public static void initialize(File logFile, String viewLog, String close) {
        LOGFILE = logFile;
        VIEWLOG = viewLog;
        CLOSE = close;
    }

    public static void setIsHeadless() {
        isHeadless = true;
    }

    private TaskDialog(String message, int icon, int buttonIndex, String[] options, boolean[] states, JCheckBox checkbox) {
        super(PARENT, TITLE, true);
        if (isHeadless) {
            System.out.println(message);
        } else {
            this.add(this.createLabels(message, icon, checkbox));
            this.add((Component)this.createButtons(options, states, buttonIndex), "South");
            this.pack();
            this.setResizable(false);
            this.setLocationRelativeTo(PARENT);
            this.setVisible(true);
        }
    }

    private JPanel createLabels(String message, int icon, JCheckBox checkbox) {
        JLabel iconLabel = new JLabel(this.getIcon(icon));
        iconLabel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        SwingUtils.addCloseHandler(this, iconLabel);
        String[] strs = message.split("\n");
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(strs.length, 1, 0, 0));
        labelPanel.setBackground(Color.white);
        for (String str : strs) {
            labelPanel.add(new JLabel(str));
        }
        JPanel labelCheckPanel = new JPanel(new BorderLayout());
        labelCheckPanel.setBorder(BorderFactory.createEmptyBorder(15, 0, 15, 15));
        labelCheckPanel.setBackground(Color.white);
        labelCheckPanel.add(labelPanel);
        if (checkbox != null) {
            checkbox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            labelCheckPanel.add((Component)checkbox, "South");
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.white);
        panel.add((Component)iconLabel, "West");
        panel.add(labelCheckPanel);
        return panel;
    }

    private JPanel createButtons(String[] options, boolean[] states, int buttonIndex) {
        DialogPanel buttonPanel = new DialogPanel();
        JButton[] buttons = new JButton[options.length];
        for (int i = 0; i < options.length; ++i) {
            int index = i;
            buttons[i] = new JButton(options[i]);
            buttons[i].addActionListener(e -> {
                this.selectedOption = index;
                this.setVisible(false);
            });
            ((Container)buttonPanel).add(buttons[i]);
            if (states == null) continue;
            buttons[i].setEnabled(states[i]);
        }
        this.getRootPane().setDefaultButton(buttons[buttonIndex]);
        return buttonPanel;
    }

    private Icon getIcon(int icon) {
        switch (icon) {
            case 0: {
                return (Icon)UIManager.get("OptionPane.errorIcon");
            }
            case 2: {
                return (Icon)UIManager.get("OptionPane.warningIcon");
            }
            case 1: {
                return (Icon)UIManager.get("OptionPane.informationIcon");
            }
            case 3: {
                return (Icon)UIManager.get("OptionPane.questionIcon");
            }
        }
        return null;
    }

    public static int show(String message, int icon, int initialSelectionValue, String[] options) {
        TaskDialog dialog = new TaskDialog(message, icon, initialSelectionValue, options, null, null);
        return dialog.selectedOption;
    }

    public static int show(String message, int icon, int initialSelectionValue, JCheckBox checkbox, String[] options) {
        TaskDialog dialog = new TaskDialog(message, icon, initialSelectionValue, options, null, checkbox);
        return dialog.selectedOption;
    }

    public static int show(String message, int icon, int initialSelectionValue, String[] options, boolean[] states) {
        TaskDialog dialog = new TaskDialog(message, icon, initialSelectionValue, options, states, null);
        return dialog.selectedOption;
    }

    public static void error(String message, String label) {
        new TaskDialog(message, 0, 0, new String[]{label}, null, null);
    }

    public static void info(String message, String label) {
        new TaskDialog(message, 1, 0, new String[]{label}, null, null);
    }

    public static void info(String message, String label, JCheckBox checkbox) {
        new TaskDialog(message, 1, 0, new String[]{label}, null, checkbox);
    }

    public static void warning(String message, String label) {
        new TaskDialog(message, 2, 0, new String[]{label}, null, null);
    }

    public static void errorWithLog(String message) {
        if (TaskDialog.show(message, 0, 1, new String[]{VIEWLOG, CLOSE}) == 0 && Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(LOGFILE);
            }
            catch (Exception e) {
                TaskDialog.error(e.getMessage(), CLOSE);
            }
        }
    }

    public static void showFileOpen(String message, String openString, int icon, File file) {
        if (TaskDialog.show(message, icon, 1, new String[]{openString, CLOSE}) == 0 && Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (Exception e) {
                TaskDialog.error(e.getMessage(), CLOSE);
            }
        }
    }

    static {
        isHeadless = false;
        LOGFILE = null;
        VIEWLOG = "View log";
        CLOSE = "Close";
    }
}

