/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.servlet.dendrogram;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import jhi.flapjack.servlet.FlapjackServlet;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.fileupload.RestletFileUpload;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import scri.commons.io.FileUtils;

public class DendrogramServerResource
extends ServerResource {
    private String id;
    private String flapjackUID;
    private int lineCount;

    public void doInit() {
        super.doInit();
        try {
            this.flapjackUID = this.getQueryValue("flapjackUID");
            this.lineCount = Integer.parseInt(this.getQueryValue("lineCount"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.id = (String)this.getRequestAttributes().get("id");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Post
    public Representation store(Representation entity) throws Exception {
        FlapjackServlet.LOG.info("####################");
        String taskId = this.flapjackUID + System.currentTimeMillis();
        File wrkDir = FlapjackServlet.getWorkingDir(taskId);
        if (entity != null && MediaType.MULTIPART_FORM_DATA.equals((Object)entity.getMediaType(), true)) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            RestletFileUpload upload = new RestletFileUpload((FileItemFactory)factory);
            FileItemIterator fileIterator = upload.getItemIterator(entity);
            while (fileIterator.hasNext()) {
                FileItemStream fi = fileIterator.next();
                if (!fi.getFieldName().equals("matrix")) continue;
                FileUtils.writeFile((File)new File(wrkDir, "matrix.txt"), (InputStream)fi.openStream());
                ArrayList<String> args = new ArrayList<String>();
                args.add("-cp");
                args.add(FlapjackServlet.fjPath);
                args.add("jhi.flapjack.servlet.dendrogram.DendrogramTask");
                args.add(FlapjackServlet.rPath);
                args.add(wrkDir.toString());
                args.add("" + this.lineCount);
                try {
                    FlapjackServlet.getScheduler().initialize();
                    String jobId = FlapjackServlet.getScheduler().submit("java", args, wrkDir.toString());
                    taskId = taskId + "-" + jobId;
                    FlapjackServlet.LOG.info("TASKID: " + taskId);
                }
                catch (Exception e) {
                    throw new ResourceException(500, (Throwable)e);
                }
            }
        } else {
            throw new ResourceException(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE);
        }
        return new StringRepresentation((CharSequence)taskId);
    }

    @Get(value="html")
    public Representation getHtml() {
        return new StringRepresentation((CharSequence)("/dendrogram - " + new Date()));
    }

    @Get(value="zip")
    public Representation getDendrogramAsZipFile() {
        try {
            String sID = this.id.substring(this.id.lastIndexOf("-") + 1);
            if (FlapjackServlet.getScheduler().isJobFinished(sID)) {
                String taskId = this.id.substring(0, this.id.indexOf("-"));
                File wrkDir = FlapjackServlet.getWorkingDir(taskId);
                File zipFile = new File(wrkDir, "results.zip");
                return new FileRepresentation(zipFile, MediaType.APPLICATION_ZIP);
            }
            this.setStatus(Status.SUCCESS_NO_CONTENT);
            return null;
        }
        catch (Exception e) {
            throw new ResourceException(500, (Throwable)e);
        }
    }

    @Delete
    public void cancelJob() {
        try {
            String sID = this.id.substring(this.id.lastIndexOf("-") + 1);
            FlapjackServlet.getScheduler().cancelJob(sID);
        }
        catch (Exception e) {
            throw new ResourceException(500, (Throwable)e);
        }
    }
}

