/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.servlet.dendrogram;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jhi.flapjack.data.results.Dendrogram;
import jhi.flapjack.data.results.SimMatrix;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.io.SimMatrixExporter;
import jhi.flapjack.servlet.dendrogram.DendrogramService;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class DendrogramClient {
    private final String baseURL = "https://ics.hutton.ac.uk/flapjack-services-20170726/";
    private String taskId;
    private Retrofit retrofit;
    private DendrogramService service;
    private final SimMatrix matrix;
    private final int lineCount;
    private ArrayList<Integer> lineOrder = new ArrayList();
    private boolean okToRun = true;
    private Thread runnerThread;

    public DendrogramClient(SimMatrix matrix, int lineCount) {
        this.matrix = matrix;
        this.lineCount = lineCount;
        this.retrofit = new Retrofit.Builder().baseUrl("https://ics.hutton.ac.uk/flapjack-services-20170726/").addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build();
        this.service = (DendrogramService)this.retrofit.create(DendrogramService.class);
    }

    public Dendrogram generateDendrogram() throws Exception {
        this.runnerThread = Thread.currentThread();
        this.taskId = this.postSimMatrix();
        if (this.okToRun) {
            Response response = this.service.getDendrogram(this.taskId).execute();
            while (this.okToRun && (!response.isSuccessful() || response.isSuccessful() && response.body() == null)) {
                System.out.println("Waiting for result...");
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.okToRun) continue;
                response = this.service.getDendrogram(this.taskId).execute();
            }
            if (this.okToRun && response.isSuccessful() && response.body() != null) {
                byte[] dendrogramBytes = ((ResponseBody)response.body()).bytes();
                return this.createDendrogramFromZip(dendrogramBytes);
            }
        }
        return null;
    }

    private String postSimMatrix() throws Exception {
        File temp = new File(FlapjackUtils.getCacheDir(), Prefs.flapjackID + ".matrix");
        SimMatrixExporter exporter = new SimMatrixExporter(this.matrix, new PrintWriter(new FileWriter(temp)));
        exporter.runJob(0);
        RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/format-data"), (File)temp);
        MultipartBody.Part body = MultipartBody.Part.createFormData((String)"matrix", (String)temp.getName(), (RequestBody)requestFile);
        Response response = this.service.postSimMatrix(body, "" + this.lineCount, Prefs.flapjackID).execute();
        return ((ResponseBody)response.body()).string();
    }

    private Dendrogram createDendrogramFromZip(byte[] zipBytes) throws IOException {
        ZipEntry entry;
        Dendrogram d = new Dendrogram();
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new ByteArrayInputStream(zipBytes)));
        while ((entry = zis.getNextEntry()) != null) {
            switch (entry.getName()) {
                case "order.txt": {
                    byte[] orderBytes = this.readBinaryZipEntry(zis);
                    this.lineOrder = this.readLineOrderFromByteArray(orderBytes);
                    break;
                }
                case "dendrogram.png": {
                    d.getPng().image = this.readBinaryZipEntry(zis);
                    break;
                }
                case "dendrogram.pdf": {
                    d.getPdf().data = this.readBinaryZipEntry(zis);
                }
            }
        }
        return d;
    }

    private byte[] readBinaryZipEntry(ZipInputStream zis) throws IOException {
        int read;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((read = zis.read(buffer, 0, buffer.length)) != -1) {
            bos.write(buffer, 0, read);
        }
        return bos.toByteArray();
    }

    private ArrayList<Integer> readLineOrderFromByteArray(byte[] orderBytes) throws IOException {
        String str;
        ArrayList<Integer> order = new ArrayList<Integer>();
        ByteArrayInputStream bis = new ByteArrayInputStream(orderBytes);
        BufferedReader in = new BufferedReader(new InputStreamReader(bis));
        while ((str = in.readLine()) != null && str.length() > 0) {
            order.add(Integer.parseInt(str) - 1);
        }
        return order;
    }

    public ArrayList<Integer> getLineOrder() {
        return this.lineOrder;
    }

    public void cancelJob() {
        if (this.runnerThread != null) {
            this.runnerThread.interrupt();
        }
        try {
            this.okToRun = false;
            this.service.cancelJob(this.taskId).execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

