/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.cmd;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Project;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.io.ChromosomeMapImporter;
import jhi.flapjack.io.FlapjackFile;
import jhi.flapjack.io.GenotypeDataImporter;
import jhi.flapjack.io.PostImportOperations;
import jhi.flapjack.io.ProjectSerializer;
import jhi.flapjack.io.ProjectSerializerDB;
import jhi.flapjack.io.QTLImporter;
import jhi.flapjack.io.TraitImporter;
import jhi.flapjack.io.cmd.CmdOptions;
import jhi.flapjack.io.cmd.CreateProjectSettings;
import jhi.flapjack.io.cmd.DataImportSettings;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;

public class CreateProject {
    private Project project = new Project();
    private DataSet dataSet = new DataSet();
    private CreateProjectSettings options;
    private List<String> output = new ArrayList<String>();
    private DataImportSettings importSettings = new DataImportSettings();

    public static void main(String[] args) {
        if (!CreateProject.useLegacyParser(args)) {
            CmdOptions options = new CmdOptions().withAdvancedOptions().withGenotypeFile(true).withProjectFile(true).withMapFile(false).withTraitFile(false).withQtlFile(false).withDataSetName(false);
            try {
                CommandLine line = new DefaultParser().parse((Options)options, args);
                CreateProjectSettings projectSettings = options.getCreateProjectSettings(line);
                DataImportSettings importSettings = options.getDataImportSettings(line);
                CreateProject cProj = new CreateProject(projectSettings, importSettings);
                cProj.doProjectCreation();
                System.exit(0);
            }
            catch (Exception e) {
                options.printHelp("CreateProject");
                System.exit(1);
            }
        }
    }

    CreateProject(CreateProjectSettings options, DataImportSettings importSettings) {
        this.options = options;
        this.importSettings = importSettings;
    }

    public List<String> doProjectCreation() {
        RB.initialize((String)"auto", (String)"res.text.flapjack");
        TaskDialog.setIsHeadless();
        FlapjackUtils.initialiseSqlite();
        if (this.importSettings.isDecimalEnglish()) {
            Locale.setDefault(Locale.UK);
        }
        try {
            this.openProject();
            this.createProject();
            this.importTraits();
            this.importQTLs();
            this.saveProject();
            ProjectSerializerDB.close();
        }
        catch (Exception e) {
            this.logMessage(e.toString());
            System.exit(1);
        }
        return this.output;
    }

    private void createProject() throws Exception {
        ChromosomeMapImporter mapImporter = new ChromosomeMapImporter(this.options.getMap(), this.dataSet);
        mapImporter.importMap();
        GenotypeDataImporter genoImporter = new GenotypeDataImporter(this.options.getGenotypes(), this.dataSet, mapImporter.getMarkersHashMap(), this.importSettings.getMissingData(), this.importSettings.getHetSep(), this.importSettings.isTransposed(), this.importSettings.isAllowDuplicates());
        genoImporter.importGenotypeData();
        if (this.importSettings.isMakeAllChrom()) {
            this.dataSet.createSuperChromosome(RB.getString((String)"io.DataImporter.allChromosomes"));
        }
        PostImportOperations pio = new PostImportOperations(this.dataSet);
        pio.collapseHomzEncodedAsHet();
        if (this.importSettings.isCollapseHeteozygotes()) {
            pio.optimizeStateTable();
        }
        pio.createDefaultView();
        if (this.options.getDatasetName() != null) {
            pio.setName(this.options.getDatasetName());
        } else if (this.options.getProject() != null) {
            pio.setName(this.options.getProject().getFile());
        }
        this.project.addDataSet(this.dataSet);
    }

    private void importTraits() throws Exception {
        if (this.options.getTraits() == null) {
            return;
        }
        this.logMessage("Importing traits from " + this.options.getTraits());
        TraitImporter importer = new TraitImporter(this.options.getTraits(), this.dataSet);
        importer.runJob(0);
        this.dataSet.getViewSets().get(0).assignTraits();
    }

    private void importQTLs() throws Exception {
        if (this.options.getQtls() == null) {
            return;
        }
        this.logMessage("Importing QTLs from " + this.options.getQtls());
        QTLImporter importer = new QTLImporter(this.options.getQtls(), this.dataSet);
        importer.runJob(0);
    }

    private void openProject() throws Exception {
        FlapjackFile prjFile = this.options.getProject();
        if (prjFile != null && prjFile.exists() && prjFile.getFile().length() > 0L) {
            this.project = ProjectSerializer.open(prjFile);
        }
    }

    void saveProject() throws Exception {
        if (this.options.getProject() != null) {
            this.project.fjFile = this.options.getProject();
            if (ProjectSerializer.save(this.project)) {
                this.logMessage("Project created");
            }
        }
    }

    private void logMessage(String message) {
        System.out.println(message);
        this.output.add(message);
    }

    DataSet dataSet() {
        return this.dataSet;
    }

    private static boolean useLegacyParser(String[] args) {
        File mapFile = null;
        File genotypesFile = null;
        File traitsFile = null;
        File qtlsFile = null;
        FlapjackFile prjFile = null;
        boolean decimalEnglish = false;
        for (String arg : args) {
            if (arg.startsWith("-map=")) {
                mapFile = new File(arg.substring(5));
            }
            if (arg.startsWith("-genotypes=")) {
                genotypesFile = new File(arg.substring(11));
            }
            if (arg.startsWith("-traits=")) {
                traitsFile = new File(arg.substring(8));
            }
            if (arg.startsWith("-qtls=")) {
                qtlsFile = new File(arg.substring(6));
            }
            if (arg.startsWith("-project=")) {
                prjFile = new FlapjackFile(arg.substring(9));
            }
            if (!arg.startsWith("-decimalEnglish")) continue;
            decimalEnglish = true;
        }
        if (genotypesFile != null && prjFile != null) {
            CreateProjectSettings projectSettings = new CreateProjectSettings(genotypesFile, mapFile, traitsFile, qtlsFile, prjFile, null);
            DataImportSettings importSettings = new DataImportSettings();
            importSettings.setDecimalEnglish(decimalEnglish);
            CreateProject cProj = new CreateProject(projectSettings, importSettings);
            cProj.doProjectCreation();
            System.exit(0);
        }
        return false;
    }
}

