/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.binning;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.NumberFormat;
import jhi.flapjack.io.binning.AutoBinner;
import jhi.flapjack.io.binning.IBinner;
import jhi.flapjack.io.binning.SplitBinner;
import jhi.flapjack.io.binning.StandardBinner;

public class BinData {
    private static IBinner binner;
    private String inFile;
    private String outFile;

    public static void main(String[] args) throws Exception {
        NumberFormat nf = NumberFormat.getInstance();
        String method = args[0].toUpperCase();
        String inFile = args[1];
        String outFile = args[2];
        BinData binData = new BinData(inFile, outFile);
        if (method.equals("STANDARD")) {
            int numBins = Integer.parseInt(args[3]);
            binData.writeStandardFile(numBins);
        } else if (method.equals("SPLIT")) {
            int lBinCount = Integer.parseInt(args[3]);
            float split = nf.parse(args[4]).floatValue();
            int rBinCount = Integer.parseInt(args[5]);
            binData.writeSplitFile(lBinCount, split, rBinCount);
        } else if (method.equals("AUTO")) {
            int numBins = Integer.parseInt(args[3]);
            String histFile = args[4];
            binData.writeAutoFile(numBins, histFile);
        }
    }

    public BinData(String inFile, String outFile) {
        this.inFile = inFile;
        this.outFile = outFile;
    }

    public void writeStandardFile(int numBins) throws Exception {
        binner = new StandardBinner(numBins);
        this.writeBinFile();
    }

    public void writeSplitFile(int lBinCount, float split, int rBinCount) throws Exception {
        binner = new SplitBinner(lBinCount, split, rBinCount);
        this.writeBinFile();
    }

    public void writeAutoFile(int numBins, String histFile) throws Exception {
        binner = new AutoBinner(numBins, histFile);
        this.writeBinFile();
    }

    private void writeBinFile() throws Exception {
        String line;
        NumberFormat nf = NumberFormat.getInstance();
        BufferedReader in = new BufferedReader(new FileReader(this.inFile));
        BufferedWriter out = new BufferedWriter(new FileWriter(this.outFile));
        out.write(in.readLine());
        out.newLine();
        while ((line = in.readLine()) != null && line.startsWith("#")) {
            if (line.startsWith("# bin")) continue;
            out.write(line);
            out.newLine();
        }
        int binNum = 0;
        for (float[] data : binner.getBinSummary()) {
            out.write("# bin\t" + binNum++ + "\t" + data[0] + "\t" + data[1]);
            out.newLine();
        }
        out.write(line);
        out.newLine();
        String str = null;
        while ((str = in.readLine()) != null && str.length() > 0) {
            String[] split = str.split("\t");
            out.write(split[0]);
            for (int i = 1; i < split.length; ++i) {
                if (split[i].isEmpty()) {
                    out.write("\t");
                    continue;
                }
                float value = nf.parse(split[i]).floatValue();
                int bin = binner.bin(value);
                out.write("\t" + bin);
            }
            out.newLine();
        }
        in.close();
        out.close();
    }
}

