/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5ReaderConfigurator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.StateTable;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.io.DataFormatException;
import jhi.flapjack.io.IGenotypeImporter;
import jhi.flapjack.io.MarkerIndex;
import scri.commons.gui.RB;

public class Hdf5GenotypeDataImporter
implements IGenotypeImporter {
    private static final String LINES = "Genotypes";
    private static final String STATE_TABLE = "StateTable";
    private static final String LINE_ROOT = "Genotypes/";
    private static final String LINE_CALLS = "/calls";
    private final File file;
    private final DataSet dataSet;
    private final StateTable stateTable;
    private boolean isOk = true;
    private HashMap<String, Line> foundLines;
    private final HashMap<String, MarkerIndex> markers;
    private final ArrayList<Integer> chromosomeIndices;
    private long markerCount;
    private long lineCount;

    Hdf5GenotypeDataImporter(File file, DataSet dataSet, HashMap<String, MarkerIndex> markers, ArrayList<Integer> markerChromosomes) {
        this.file = file;
        this.dataSet = dataSet;
        this.markers = markers;
        this.chromosomeIndices = markerChromosomes;
        this.stateTable = dataSet.getStateTable();
    }

    @Override
    public void importGenotypeData() throws IOException, DataFormatException {
        String[] states;
        long s = System.currentTimeMillis();
        this.foundLines = new HashMap();
        System.out.println("Marker Chromosomes.size()" + this.chromosomeIndices.size());
        IHDF5ReaderConfigurator config = HDF5Factory.configureForReading((File)this.file);
        IHDF5Reader reader = config.reader();
        List lines = reader.getGroupMembers(LINES);
        for (String state : states = reader.readStringArray(STATE_TABLE)) {
            this.stateTable.getStateCode(state, true, Prefs.ioMissingData, Prefs.ioHeteroSeparator);
        }
        boolean useByteStorage = this.stateTable.size() < 127;
        for (String name : lines) {
            if (this.foundLines.get(name) != null) {
                throw new DataFormatException(RB.format((String)"io.DataFormatException.duplicateLineError", (Object[])new Object[]{name, this.lineCount + 1L}));
            }
            Line line = this.dataSet.createLine(name, useByteStorage);
            this.foundLines.put(name, line);
            int[] alleleStates = reader.readIntArray(LINE_ROOT + name + LINE_CALLS);
            HashMap<Integer, ArrayList<Integer>> allelesByChromosome = this.sortAllelesIntoChromosomes(alleleStates, this.chromosomeIndices);
            for (Map.Entry<Integer, ArrayList<Integer>> entry : allelesByChromosome.entrySet()) {
                if (!this.isOk) break;
                int i = 0;
                for (int allele : entry.getValue()) {
                    line.setLoci(entry.getKey(), i++, allele);
                    ++this.markerCount;
                }
            }
            ++this.lineCount;
        }
        System.out.println("Time taken to read genotypes: " + (System.currentTimeMillis() - s) + " ms");
    }

    private HashMap<Integer, ArrayList<Integer>> sortAllelesIntoChromosomes(int[] alleleStates, ArrayList<Integer> chromIndices) {
        int chromosomeIndex = 0;
        HashMap<Integer, ArrayList<Integer>> allelesByChromosome = new HashMap<Integer, ArrayList<Integer>>();
        ArrayList<Integer> alleles = new ArrayList<Integer>();
        for (int i = 0; i < chromIndices.size(); ++i) {
            if (chromIndices.get(i) != chromosomeIndex) {
                allelesByChromosome.put(chromosomeIndex, alleles);
                alleles = new ArrayList();
                chromosomeIndex = chromIndices.get(i);
            }
            alleles.add(alleleStates[i]);
        }
        allelesByChromosome.put(chromosomeIndex, alleles);
        return allelesByChromosome;
    }

    @Override
    public void cleanUp() {
        this.markers.clear();
        this.foundLines.clear();
    }

    @Override
    public void cancelImport() {
        this.isOk = false;
    }

    @Override
    public long getMarkerCount() {
        return this.markerCount;
    }

    @Override
    public long getLineCount() {
        return this.lineCount;
    }

    @Override
    public long getBytesRead() {
        return 0L;
    }
}

