/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import jhi.flapjack.data.BinnedData;
import jhi.flapjack.data.DBAssociation;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.StateTable;
import scri.commons.gui.SimpleJob;

public class GenotypeDataExporter
extends SimpleJob {
    private File file;
    private GTViewSet viewSet;
    private boolean useAll;
    private boolean[] chrm;

    public GenotypeDataExporter(File file, GTViewSet viewSet, boolean useAll, boolean[] chrm, int total) {
        this.file = file;
        this.viewSet = viewSet;
        this.useAll = useAll;
        this.chrm = chrm;
        this.maximum = total;
    }

    public void runJob(int index) throws IOException {
        GTView view;
        BinnedData binnedData;
        BufferedWriter out = new BufferedWriter(new FileWriter(this.file));
        out.write("# fjFile = GENOTYPE");
        out.newLine();
        DBAssociation db = this.viewSet.getDataSet().getDbAssociation();
        if (db.isLineSearchEnabled()) {
            out.write("# fjDatabaseLineSearch = " + db.getLineSearch());
            out.newLine();
        }
        if (db.isMarkerSearchEnabled()) {
            out.write("# fjDatabaseMarkerSearch = " + db.getMarkerSearch());
            out.newLine();
        }
        if (db.isGroupPreivewEnabled()) {
            out.write("# fjDatabaseGroupPreview = " + db.getGroupPreview());
            out.newLine();
        }
        if (db.isGroupUploadEnabled()) {
            out.write("# fjDatabaseGroupUpload = " + db.getGroupUpload());
            out.newLine();
        }
        if (db.isLineSearchEnabled() || db.isMarkerSearchEnabled() || db.isGroupPreivewEnabled() || db.isGroupUploadEnabled()) {
            out.newLine();
        }
        if ((binnedData = this.viewSet.getDataSet().getBinnedData()).containsBins()) {
            for (BinnedData.BinData binData : binnedData.getBins()) {
                out.write("# bin\t" + binData.index + "\t" + binData.min + "\t" + binData.max);
                out.newLine();
            }
        }
        out.write("\t");
        for (int c = 0; c < this.viewSet.chromosomeCount(); ++c) {
            view = this.viewSet.getView(c);
            if (this.chrm != null && !this.chrm[c]) continue;
            for (int i = 0; i < view.markerCount(); ++i) {
                if (!this.useAll && !view.isMarkerSelected(i) || view.getMarker(i).dummyMarker()) continue;
                out.write(view.getMarker(i).getName() + "\t");
            }
        }
        out.newLine();
        StateTable stateTable = this.viewSet.getDataSet().getStateTable();
        view = this.viewSet.getView(0);
        int line = 0;
        while (line < view.lineCount()) {
            if (!(view.isDummyLine(line) || view.isSplitter(line) || view.isDuplicate(line) || !this.useAll && !view.isLineSelected(line))) {
                out.write(view.getLine(line).getName() + "\t");
                for (int v = 0; v < this.viewSet.chromosomeCount(); ++v) {
                    GTView cView = this.viewSet.getView(v);
                    if (this.chrm != null && !this.chrm[v]) continue;
                    for (int marker = 0; marker < cView.markerCount() && this.okToRun; ++marker) {
                        if (!this.useAll && !cView.isMarkerSelected(marker) || cView.getMarker(marker).dummyMarker()) continue;
                        int state = cView.getState(line, marker);
                        out.write(stateTable.getAlleleState(state) + "\t");
                    }
                }
                out.newLine();
            }
            ++line;
            ++this.progress;
        }
        out.close();
    }
}

