/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.colors.ColorState;

public class HomozygousColorState
extends ColorState {
    HomozygousColorState(AlleleState state, Color c, int w, int h) {
        super(state, c, w, h);
        this.image = this.createBuffer(this.color, false);
        this.imageUnderQTL = this.createBuffer(this.color, true);
        this.createUnselectedImage(w, h);
    }

    private BufferedImage createBuffer(Color c, boolean isUnderQTL) {
        BufferedImage image = new BufferedImage(this.w, this.h, 1);
        Graphics2D g = image.createGraphics();
        Color c1 = c.brighter();
        Color c2 = c.darker();
        if (Prefs.visDisableGradients) {
            g.setColor(c);
        } else {
            g.setPaint(new GradientPaint(0.0f, 0.0f, c1, this.w, this.h, c2));
        }
        Rectangle2D.Float r = null;
        r = new Rectangle2D.Float(0.0f, 0.0f, this.w, this.h);
        g.fill(r);
        if (isUnderQTL) {
            // empty if block
        }
        if (Prefs.visShowGenotypes && this.h >= 7 && Prefs.visLinkSliders) {
            String str = this.state.homzAllele();
            Font font = g.getFont().deriveFont(0, this.h - 3);
            g.setFont(font);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D bounds = fm.getStringBounds(str, g);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Prefs.visColorText);
            g.drawString(str, (int)((double)((float)this.w / 2.0f) - bounds.getWidth() / 2.0), this.h - fm.getMaxDescent());
        }
        if (Prefs.visHighlightHtZ || Prefs.visHighlightGaps && c != Prefs.visColorBackground || alpha < 200) {
            g.setPaint(new Color(20, 20, 20, alpha));
            g.fillRect(0, 0, this.w, this.h);
        }
        g.dispose();
        return image;
    }
}

