/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.Marker;
import jhi.flapjack.gui.visualization.ChromosomeCanvasGraph;
import jhi.flapjack.gui.visualization.ChromosomeCanvasKey;
import scri.commons.gui.RB;

class ChromosomeCanvas
extends JPanel {
    private GTViewSet viewSet;
    private ChromosomeCanvasKey key;
    private ChromosomeCanvasGraph graph;
    ArrayList<GTView> views;
    private Dimension dimension = new Dimension();
    BufferedImage imageViewPort;
    private boolean redraw = true;
    Point mousePos;
    private int maxMarkers;
    private int minMarkers;
    ArrayList<float[]> viewMarkersPerPixel;
    private ArrayList<Integer> viewMapWidths;
    double cmPerPixel;
    private NumberFormat nf = NumberFormat.getInstance();

    ChromosomeCanvas() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ChromosomeCanvas.this.redraw = true;
                ChromosomeCanvas.this.repaint();
            }
        });
        new CanvasMouseListener(this);
        ToolTipManager.sharedInstance().setInitialDelay(0);
    }

    void setHelpers(ChromosomeCanvasKey key, ChromosomeCanvasGraph graph) {
        this.key = key;
        this.graph = graph;
    }

    void setView(GTViewSet viewSet) {
        this.viewSet = viewSet;
        viewSet.getCustomMaps().initForDisplay(viewSet);
        this.views = viewSet.getCustomMaps().getAllViews();
        this.dimension = new Dimension(this.getWidth(), this.views.size() * 70);
        this.redraw = true;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.dimension;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g = (Graphics2D)graphics;
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.redraw) {
            long s = System.currentTimeMillis();
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.imageViewPort == null || this.imageViewPort.getWidth() != w || this.imageViewPort.getHeight() != h) {
                this.imageViewPort = (BufferedImage)this.createImage(w, h);
            }
            Graphics2D gImage = this.imageViewPort.createGraphics();
            this.renderCanvas(gImage);
            gImage.dispose();
            System.out.println("Render time: " + (System.currentTimeMillis() - s));
        }
        g.drawImage((Image)this.imageViewPort, 0, 0, null);
        this.redraw = false;
    }

    private void renderCanvas(Graphics2D g) {
        double longestMap = 0.0;
        for (GTView view : this.views) {
            longestMap = Math.max(longestMap, view.mapLength());
        }
        int longestMapW = this.getWidth() - 50;
        this.cmPerPixel = longestMap / (double)longestMapW;
        NumberFormat nf = NumberFormat.getInstance();
        g.setFont((Font)UIManager.get("Label.font"));
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int y = 25;
        this.calculateMarkersPerPixel(longestMap, longestMapW);
        this.key.redraw();
        int viewNo = 0;
        for (GTView view : this.views) {
            int mapW = (int)(view.mapLength() / longestMap * (double)longestMapW);
            g.setColor(Color.BLACK);
            String name = view.getChromosomeMap().getName() + ": " + RB.format((String)"gui.visualization.ChromosomeCanvas.markers", (Object[])new Object[]{nf.format(view.markerCount())});
            g.drawString(name, 25, y);
            y += 5;
            float[] markersPerPixel = this.viewMarkersPerPixel.get(viewNo);
            for (int i = 0; i < mapW; ++i) {
                float percent = markersPerPixel[i] / (float)this.maxMarkers;
                int alpha = 0 + (int)(255.0f * (255.0f * percent) / 255.0f);
                g.setColor(new Color(70, 116, 162, alpha));
                g.drawLine(i + 25, y, i + 25, y + 16);
            }
            g.setColor(Color.black);
            g.drawRect(25, y, mapW, 16);
            g.setColor(Color.black);
            g.drawString(nf.format(0L), 25, y += 30);
            String strLength = nf.format(view.mapLength());
            int strWidth = g.getFontMetrics().stringWidth(strLength);
            int strPos = 25 + mapW - strWidth;
            if (strPos < 25) {
                strPos = 40;
            }
            g.drawString(strLength, strPos, y);
            y += 35;
            ++viewNo;
        }
    }

    private void calculateMarkersPerPixel(double longestMap, int longestMapW) {
        this.maxMarkers = 0;
        this.minMarkers = Integer.MAX_VALUE;
        this.viewMarkersPerPixel = new ArrayList();
        this.viewMapWidths = new ArrayList();
        for (GTView view : this.views) {
            int nBins = (int)(view.mapLength() / longestMap * (double)longestMapW);
            this.viewMapWidths.add(nBins);
            float[] markersPerPixel = this.calculateMarkersPerPixel(view, this.cmPerPixel, nBins);
            this.viewMarkersPerPixel.add(markersPerPixel);
        }
    }

    float[] calculateMarkersPerPixel(GTView view, double cmPerPixel, int nBins) {
        float[] markersPerPixel = new float[nBins];
        int startMarker = 0;
        for (int pixel = 1; pixel <= nBins; ++pixel) {
            Marker m;
            int markerCount = 0;
            double pixelPosition = (double)pixel * cmPerPixel;
            for (int i = startMarker; i < view.markerCount() && (m = view.getMarker(i)).getPosition() <= pixelPosition; ++i) {
                ++markerCount;
                ++startMarker;
            }
            markersPerPixel[pixel - 1] = markerCount;
            this.maxMarkers = Math.max(this.maxMarkers, markerCount);
            this.minMarkers = Math.min(this.minMarkers, markerCount);
        }
        return markersPerPixel;
    }

    int maxMarkerCount() {
        return this.maxMarkers;
    }

    int minMarkerCount() {
        return this.minMarkers;
    }

    class CanvasMouseListener
    extends MouseInputAdapter {
        CanvasMouseListener(ChromosomeCanvas canvas) {
            canvas.addMouseListener(this);
            canvas.addMouseMotionListener(this);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ChromosomeCanvas.this.mousePos = e.getPoint();
            ChromosomeCanvas.this.setToolTipText(null);
            for (int i = 0; i < ChromosomeCanvas.this.viewMarkersPerPixel.size(); ++i) {
                int pixel;
                if (!(ChromosomeCanvas.this.mousePos.getY() > (double)(30 + i * 70)) || !(ChromosomeCanvas.this.mousePos.getY() < (double)(30 + i * 70 + 16)) || (pixel = (int)ChromosomeCanvas.this.mousePos.getX() - 25) <= 0 || pixel >= (Integer)ChromosomeCanvas.this.viewMapWidths.get(i)) continue;
                ChromosomeCanvas.this.setToolTipText("<html>" + RB.format((String)"gui.visualization.ChromosomeCanvas.positonTooltip", (Object[])new Object[]{ChromosomeCanvas.this.nf.format((double)pixel * ChromosomeCanvas.this.cmPerPixel)}) + "<br>" + RB.format((String)"gui.visualization.ChromsomeCanvas.densityTooltip", (Object[])new Object[]{Float.valueOf(ChromosomeCanvas.this.viewMarkersPerPixel.get(i)[pixel])}));
            }
            ChromosomeCanvas.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ChromosomeCanvas.this.mousePos = null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            for (int i = 0; i < ChromosomeCanvas.this.viewMarkersPerPixel.size(); ++i) {
                if (!(ChromosomeCanvas.this.mousePos.getY() > (double)(30 + i * 70)) || !(ChromosomeCanvas.this.mousePos.getY() < (double)(30 + i * 70 + 16))) continue;
                ChromosomeCanvas.this.graph.display(i);
            }
        }
    }
}

