/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.simmatrix;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.results.SimMatrix;
import jhi.flapjack.gui.TitlePanel;
import jhi.flapjack.gui.simmatrix.CanvasController;
import jhi.flapjack.gui.simmatrix.SimMatrixCanvas;
import jhi.flapjack.gui.simmatrix.SimMatrixCanvasML;
import jhi.flapjack.gui.simmatrix.SimMatrixPanelNB;
import jhi.flapjack.io.ProjectSerializerDB;

public class SimMatrixPanel
extends JPanel
implements AncestorListener {
    private GTViewSet viewSet;
    private SimMatrix matrix;
    private SimMatrixCanvas sCanvas;
    private CanvasController controller;
    private JScrollPane sp;
    private SimMatrixPanelNB nbPanel;

    public SimMatrixPanel(GTViewSet viewSet, SimMatrix matrix) {
        this.viewSet = viewSet;
        this.matrix = matrix;
        this.createControls();
        this.addAncestorListener(this);
    }

    public GTViewSet getViewSet() {
        return this.viewSet;
    }

    public SimMatrix getSimMatrix() {
        return this.matrix;
    }

    private void createControls() {
        this.sCanvas = new SimMatrixCanvas(this, this.matrix);
        this.sp = new JScrollPane();
        this.sp.setViewportView(this.sCanvas);
        this.sp.setWheelScrollingEnabled(false);
        this.controller = new CanvasController(this, this.sp);
        new SimMatrixCanvasML(this, this.controller);
        this.nbPanel = new SimMatrixPanelNB(this.viewSet, this.matrix, this.sp);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)new TitlePanel(this.matrix.getTitle()), "North");
        this.add(this.nbPanel);
    }

    SimMatrixCanvas getSimMatrixCanvas() {
        return this.sCanvas;
    }

    CanvasController getController() {
        return this.controller;
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        ProjectSerializerDB.setFromCache(this.matrix);
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        this.matrix.dbClear();
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }
}

