/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.mabc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.gui.TitlePanel;
import jhi.flapjack.gui.mabc.MabcPanelNB;
import jhi.flapjack.gui.mabc.MabcTableModel;
import jhi.flapjack.gui.table.ITableViewListener;
import jhi.flapjack.gui.table.LineDataTable;
import jhi.flapjack.gui.table.LinkedTableHandler;
import scri.commons.gui.Icons;
import scri.commons.gui.RB;

public class MabcPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
ITableViewListener,
TableModelListener {
    private LineDataTable table;
    private MabcTableModel model;
    private GTViewSet viewSet;
    private LinkedTableHandler tableHandler;
    private MabcPanelNB controls = new MabcPanelNB(this);
    private int qtlStatusCount = 0;
    private int rank = 1;

    public MabcPanel(GTViewSet viewSet) {
        this.viewSet = viewSet;
        this.table = (LineDataTable)this.controls.table;
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addViewListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)new TitlePanel(RB.getString((String)"gui.mabc.MabcPanel.title")), "North");
        this.add(this.controls);
        this.updateModel(viewSet);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MabcPanel.this.handlePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MabcPanel.this.handlePopup(e);
            }
        });
        this.tableHandler = viewSet.tableHandler();
        this.tableHandler.linkTable(this.table, this.model);
        this.controls.autoResize.setSelected(this.tableHandler.isAutoResize());
    }

    private void updateModel(GTViewSet viewset) {
        this.model = new MabcTableModel(viewset);
        this.model.addTableModelListener(this);
        this.table.setModel(this.model);
        this.table.setViewSet(this.viewSet);
        this.tableFiltered();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.controls.bSort) {
            this.table.sortDialog();
        } else if (e.getSource() == this.controls.bExport) {
            this.table.exportData();
        } else if (e.getSource() == this.controls.bRank) {
            this.rank = this.table.rankSelectedLines(this.rank, this.model.getRankIndex());
        } else if (e.getSource() == this.controls.autoResize) {
            this.table.autoResize(this.controls.autoResize.isSelected(), false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.controls.bRank.setEnabled(this.table.getSelectionModel().getMinSelectionIndex() != -1);
    }

    private void handlePopup(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        JPopupMenu menu = this.table.getMenu().createPopupMenu();
        JMenuItem mRank = new JMenuItem();
        mRank.setText("Rank...");
        mRank.setIcon(Icons.getIcon((String)"RANK"));
        mRank.addActionListener(event -> {
            this.rank = this.table.rankSelectedLines(this.rank, this.model.getRankIndex());
        });
        mRank.setEnabled(this.table.getSelectionModel().getMinSelectionIndex() != -1);
        menu.add((Component)mRank, 1);
        menu.add((Component)new JPopupMenu.Separator(), 2);
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void tablePreSorted() {
    }

    @Override
    public void tableSorted() {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.tableFiltered();
    }

    @Override
    public void tableFiltered() {
        this.controls.filterLabel.setText(this.table.getLineStatusText());
    }
}

