/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.dialog.analysis.ChromosomeSelectionDialog;
import scri.commons.gui.RB;
import scri.commons.gui.matisse.DialogPanel;
import scri.commons.gui.matisse.HyperLinkLabel;

public class HeterozygousMarkersDialog
extends JDialog
implements ActionListener,
ChangeListener {
    private final GTViewSet viewSet;
    private boolean isOK = false;
    private int value = Prefs.guiHeterozygousMarkerPcnt;
    private ChromosomeSelectionDialog csd;
    private JButton bCancel;
    private JButton bFilter;
    private JButton bHelp;
    private HyperLinkLabel csdLabel;
    private JPanel dataPanel;
    private DialogPanel dialogPanel1;
    private JPanel jPanel1;
    private JPanel panel1;
    private JLabel percentLabel;
    private JSlider slider;

    public HeterozygousMarkersDialog(GTViewSet viewSet) {
        super(Flapjack.winMain, RB.getString((String)"gui.dialog.HeterozygousMarkersDialog.title"), true);
        this.viewSet = viewSet;
        this.initComponents();
        this.initComponents2();
        if (viewSet.getView(0).countSelectedLines() == 0) {
            this.bFilter.setEnabled(false);
        }
        FlapjackUtils.initDialog(this, this.bFilter, this.bCancel, true, this.getContentPane(), this.jPanel1, this.panel1, this.dataPanel);
    }

    private void initComponents2() {
        RB.setText((AbstractButton)this.bFilter, (String)"gui.dialog.HeterozygousMarkersDialog.filter");
        this.bFilter.addActionListener(this);
        RB.setText((AbstractButton)this.bCancel, (String)"gui.text.cancel");
        this.bCancel.addActionListener(this);
        RB.setText((AbstractButton)this.bHelp, (String)"gui.text.help");
        FlapjackUtils.setHelp(this.bHelp, "filtering_markers.html");
        this.slider.addChangeListener(this);
        this.slider.setValue(this.value);
        this.csd = new ChromosomeSelectionDialog(this.viewSet, false);
        this.csdLabel.addActionListener(e -> this.csd.setVisible(true));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bFilter) {
            this.applySettings();
            this.isOK = true;
        }
        this.setVisible(false);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.value = this.slider.getValue();
        this.formatLabel();
    }

    private void formatLabel() {
        this.percentLabel.setText(RB.format((String)"gui.dialog.HeterozygousMarkersDialog.percentLabel", (Object[])new Object[]{this.value}));
    }

    void applySettings() {
        Prefs.guiHeterozygousMarkerPcnt = this.value;
    }

    public boolean isOK() {
        return this.isOK;
    }

    public boolean[] getSelectedChromosomes() {
        return this.csd.getSelectedChromosomes();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.panel1 = new JPanel();
        this.percentLabel = new JLabel();
        this.slider = new JSlider();
        this.dataPanel = new JPanel();
        this.csdLabel = new HyperLinkLabel();
        this.dialogPanel1 = new DialogPanel();
        this.bFilter = new JButton();
        this.bCancel = new JButton();
        this.bHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.panel1.setBorder(BorderFactory.createTitledBorder("Filtering settings:"));
        this.percentLabel.setText("Only hide markers with greater than 95% missing data:");
        this.slider.setMajorTickSpacing(20);
        this.slider.setMinorTickSpacing(10);
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.setValue(95);
        this.slider.setOpaque(false);
        GroupLayout panel1Layout = new GroupLayout(this.panel1);
        this.panel1.setLayout(panel1Layout);
        panel1Layout.setHorizontalGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panel1Layout.createSequentialGroup().addContainerGap().addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.percentLabel, -1, -1, Short.MAX_VALUE).addComponent(this.slider, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        panel1Layout.setVerticalGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panel1Layout.createSequentialGroup().addContainerGap().addComponent(this.percentLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slider, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Data selection settings:"));
        this.csdLabel.setText("Select chromosomes to filter across");
        GroupLayout dataPanelLayout = new GroupLayout(this.dataPanel);
        this.dataPanel.setLayout(dataPanelLayout);
        dataPanelLayout.setHorizontalGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataPanelLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.csdLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        dataPanelLayout.setVerticalGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataPanelLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.csdLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panel1, -1, -1, Short.MAX_VALUE).addComponent(this.dataPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.panel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.bFilter.setText("Filter");
        this.dialogPanel1.add((Component)this.bFilter);
        this.bCancel.setText("Cancel");
        this.dialogPanel1.add((Component)this.bCancel);
        this.bHelp.setText("Help");
        this.dialogPanel1.add((Component)this.bHelp);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dialogPanel1, -1, 400, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dialogPanel1, -2, 44, -2)));
        this.pack();
    }
}

