/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import jhi.flapjack.data.Project;
import jhi.flapjack.gui.MenuAnalysis;
import jhi.flapjack.gui.MenuData;
import jhi.flapjack.gui.MenuEdit;
import jhi.flapjack.gui.MenuFile;
import jhi.flapjack.gui.MenuHelp;
import jhi.flapjack.gui.MenuView;
import jhi.flapjack.gui.MenuVisualization;
import jhi.flapjack.gui.NavPanel;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.WinMainMenuBar;
import jhi.flapjack.gui.WinMainStatusBar;
import jhi.flapjack.gui.WinMainToolBar;
import jhi.flapjack.gui.dialog.FilterQTLsDialog;
import jhi.flapjack.gui.dialog.SelectGraphDialog;
import jhi.flapjack.gui.dialog.analysis.FindDialog;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.io.ProjectSerializer;
import scri.commons.gui.Icons;
import scri.commons.gui.Install4j;
import scri.commons.gui.RB;
import scri.commons.gui.SwingUtils;

public class WinMain
extends JFrame {
    private WinMainMenuBar menubar;
    private WinMainToolBar toolbar;
    private WinMainStatusBar statusbar;
    private NavPanel navPanel;
    private GenotypePanel gPanel;
    private FindDialog findDialog;
    public FilterQTLsDialog filterQTLDialog;
    public SelectGraphDialog selectGraphDialog;
    private Project project = new Project();
    public MenuFile mFile = new MenuFile();
    public MenuEdit mEdit = new MenuEdit();
    public MenuView mView = new MenuView();
    public MenuVisualization mViz = new MenuVisualization();
    public MenuAnalysis mAnalysis = new MenuAnalysis();
    public MenuData mData = new MenuData();
    MenuHelp mHelp = new MenuHelp();

    WinMain() {
        this.setTitle(RB.getString((String)"gui.WinMain.title") + " - " + Install4j.VERSION);
        this.setIconImage(Icons.getIcon((String)"FLAPJACK").getImage());
        this.menubar = new WinMainMenuBar(this);
        this.toolbar = new WinMainToolBar();
        this.setJMenuBar(this.menubar);
        this.navPanel = new NavPanel(this);
        this.gPanel = this.navPanel.getGenotypePanel();
        this.statusbar = new WinMainStatusBar(this.gPanel);
        this.mFile.setComponents(this, this.menubar, this.navPanel);
        this.mEdit.setComponents(this.gPanel);
        this.mView.setComponents(this.navPanel);
        this.mViz.setComponents(this.navPanel);
        this.mAnalysis.setComponents(this, this.navPanel);
        this.mData.setComponents(this, this.navPanel);
        this.mHelp.setComponents(this.gPanel);
        this.add((Component)this.toolbar, "North");
        this.add(this.navPanel);
        this.add((Component)this.statusbar, "South");
        this.setSize(Prefs.guiWinMainW, Prefs.guiWinMainH);
        this.setDefaultCloseOperation(0);
        SwingUtils.positionWindow((Window)this, null, (int)Prefs.guiWinMainX, (int)Prefs.guiWinMainY);
        if (Prefs.guiWinMainMaximized) {
            this.setExtendedState(6);
        }
        this.addListeners();
    }

    private void addListeners() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (WinMain.this.getExtendedState() != 6) {
                    Prefs.guiWinMainW = WinMain.this.getSize().width;
                    Prefs.guiWinMainH = WinMain.this.getSize().height;
                    Prefs.guiWinMainX = WinMain.this.getLocation().x;
                    Prefs.guiWinMainY = WinMain.this.getLocation().y;
                    Prefs.guiWinMainMaximized = false;
                } else {
                    Prefs.guiWinMainMaximized = true;
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                if (WinMain.this.getExtendedState() != 6) {
                    Prefs.guiWinMainX = WinMain.this.getLocation().x;
                    Prefs.guiWinMainY = WinMain.this.getLocation().y;
                }
            }
        });
    }

    boolean okToExit() {
        return ProjectSerializer.okToContinue(this.project, true);
    }

    public Project getProject() {
        return this.project;
    }

    void setProject(Project project) {
        this.project = project;
    }

    WinMainMenuBar getWinMainMenuBar() {
        return this.menubar;
    }

    FindDialog getFindDialog() {
        if (this.findDialog == null) {
            this.findDialog = new FindDialog(this, this.gPanel);
        }
        return this.findDialog;
    }

    void fileExit() {
        WindowEvent evt = new WindowEvent(this, 201);
        this.processWindowEvent(evt);
    }

    public void hideDialogs() {
        if (this.findDialog != null) {
            this.findDialog.setVisible(false);
        }
        if (this.filterQTLDialog != null) {
            this.filterQTLDialog.setVisible(false);
        }
    }

    public GenotypePanel getGenotypePanel() {
        return this.navPanel.getGenotypePanel();
    }

    public NavPanel getNavPanel() {
        return this.navPanel;
    }
}

