/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.data.pedigree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.XMLRoot;
import jhi.flapjack.data.pedigree.PedLineInfo;
import jhi.flapjack.io.DataFormatException;

public class PedManager
extends XMLRoot {
    private ArrayList<PedLineInfo> pedigrees = new ArrayList();
    private ArrayList<Line> parents;

    public ArrayList<PedLineInfo> getPedigrees() {
        return this.pedigrees;
    }

    public void setPedigrees(ArrayList<PedLineInfo> pedigrees) {
        this.pedigrees = pedigrees;
    }

    /*
     * Could not resolve type clashes
     */
    public void create(ArrayList<String> triplets, HashMap<String, ArrayList<Line>> linesByName) throws DataFormatException {
        for (String str : triplets) {
            String[] tokens = str.split("\t");
            ArrayList<Line> parents = linesByName.get(tokens[1]);
            if (parents == null) {
                System.err.println("WARNING: Pedigree header references germplasm '" + tokens[1] + "' that does not exist");
                continue;
            }
            int type = 0;
            switch (tokens[2]) {
                case "RP": {
                    type = 1;
                    break;
                }
                case "DP": {
                    type = 2;
                }
            }
            if (tokens[0].equals("*")) {
                for (Map.Entry entry : linesByName.entrySet()) {
                    for (Line progeny : (ArrayList)entry.getValue()) {
                        for (Line parent : parents) {
                            if (progeny.getName().equals(parent.getName())) continue;
                            this.pedigrees.add(new PedLineInfo(progeny, parent, type));
                        }
                    }
                }
                continue;
            }
            ArrayList<Line> progenies = linesByName.get(tokens[0]);
            if (progenies == null) {
                System.err.println("WARNING: Pedigree header references germplasm '" + tokens[0] + "' that does not exist");
                continue;
            }
            for (Line progeny : progenies) {
                for (Line parent : parents) {
                    this.pedigrees.add(new PedLineInfo(progeny, parent, type));
                }
            }
        }
    }

    public ArrayList<PedLineInfo> getParentsForLine(LineInfo lineInfo) {
        Line line = lineInfo.getLine();
        ArrayList<PedLineInfo> parents = new ArrayList<PedLineInfo>();
        for (PedLineInfo pedInfo : this.pedigrees) {
            if (pedInfo.getProgeny() != line) continue;
            parents.add(pedInfo);
        }
        return parents;
    }

    public boolean isRP(LineInfo lineInfo) {
        Line line = lineInfo.getLine();
        for (PedLineInfo pedInfo : this.pedigrees) {
            if (pedInfo.getParent() != line || pedInfo.getType() != 1) continue;
            return true;
        }
        return false;
    }

    public boolean isDP(LineInfo lineInfo) {
        Line line = lineInfo.getLine();
        for (PedLineInfo pedInfo : this.pedigrees) {
            if (pedInfo.getParent() != line || pedInfo.getType() != 2) continue;
            return true;
        }
        return false;
    }

    public boolean isParent(LineInfo lineInfo) {
        if (this.parents == null) {
            this.parents = this.pedigrees.stream().map(PedLineInfo::getParent).distinct().collect(Collectors.toCollection(ArrayList::new));
        }
        return this.parents.contains(lineInfo.getLine());
    }
}

