/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.data;

import java.util.ArrayList;
import jhi.flapjack.data.BinnedData;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.DBAssociation;
import jhi.flapjack.data.FavAlleleManager;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.Marker;
import jhi.flapjack.data.StateTable;
import jhi.flapjack.data.Trait;
import jhi.flapjack.data.XMLRoot;
import jhi.flapjack.data.pedigree.PedManager;

public class DataSet
extends XMLRoot {
    private String name;
    private ArrayList<ChromosomeMap> chromosomes = new ArrayList();
    private ArrayList<Line> lines = new ArrayList();
    private Line dummyLine;
    private Line splitter;
    private ArrayList<Trait> traits = new ArrayList();
    private StateTable stateTable = new StateTable(0);
    private ArrayList<GTViewSet> viewSets = new ArrayList();
    private DBAssociation dbAssociation = new DBAssociation();
    private int matrixCount;
    private int dendrogramCount;
    private int mabcCount;
    private boolean colorTraitTable = true;
    private BinnedData bins = new BinnedData();
    public static final int DUMMY_COUNT = 5;
    private PedManager pm = new PedManager();
    private FavAlleleManager fm = new FavAlleleManager();

    void validate() throws NullPointerException {
        if (this.name == null) {
            throw new NullPointerException();
        }
        for (ChromosomeMap map : this.chromosomes) {
            map.validate();
        }
        for (Line line : this.lines) {
            line.validate();
        }
        for (Trait trait : this.traits) {
            trait.validate();
        }
        this.dummyLine = this.lines.get(0).createDummy();
        this.splitter = this.lines.get(0).createDummy();
        this.stateTable.validate();
        for (GTViewSet viewSet : this.viewSets) {
            viewSet.validate();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<ChromosomeMap> getChromosomeMaps() {
        return this.chromosomes;
    }

    public void setChromosomeMaps(ArrayList<ChromosomeMap> chromosomes) {
        this.chromosomes = chromosomes;
    }

    public ArrayList<Line> getLines() {
        return this.lines;
    }

    public void setLines(ArrayList<Line> lines) {
        this.lines = lines;
    }

    public Line getDummyLine() {
        return this.dummyLine;
    }

    public void setDummyLine(Line dummyLine) {
        this.dummyLine = dummyLine;
    }

    public Line getSplitter() {
        return this.splitter;
    }

    public void setSplitter(Line splitter) {
        this.splitter = splitter;
    }

    public ArrayList<Trait> getTraits() {
        return this.traits;
    }

    public void setTraits(ArrayList<Trait> traits) {
        this.traits = traits;
    }

    public StateTable getStateTable() {
        return this.stateTable;
    }

    public void setStateTable(StateTable stateTable) {
        this.stateTable = stateTable;
    }

    public ArrayList<GTViewSet> getViewSets() {
        return this.viewSets;
    }

    public void setViewSets(ArrayList<GTViewSet> viewSets) {
        this.viewSets = viewSets;
    }

    public DBAssociation getDbAssociation() {
        return this.dbAssociation;
    }

    public void setDbAssociation(DBAssociation dbAssociation) {
        this.dbAssociation = dbAssociation;
    }

    public int getMatrixCount() {
        return this.matrixCount;
    }

    public void setMatrixCount(int matrixCount) {
        this.matrixCount = matrixCount;
    }

    public int getDendrogramCount() {
        return this.dendrogramCount;
    }

    public void setDendrogramCount(int dendrogramCount) {
        this.dendrogramCount = dendrogramCount;
    }

    public int getMabcCount() {
        return this.mabcCount;
    }

    public void setMabcCount(int mabcCount) {
        this.mabcCount = mabcCount;
    }

    public boolean getColorTraitTable() {
        return this.colorTraitTable;
    }

    public void setColorTraitTable(boolean colorTraitTable) {
        this.colorTraitTable = colorTraitTable;
    }

    public BinnedData getBinnedData() {
        return this.bins;
    }

    public void setBinnedData(BinnedData binnedData) {
        this.bins = binnedData;
    }

    public PedManager getPedManager() {
        return this.pm;
    }

    public void setPedManager(PedManager pm) {
        this.pm = pm;
    }

    public FavAlleleManager getFavAlleleManager() {
        return this.fm;
    }

    public void setFavAlleleManager(FavAlleleManager fm) {
        this.fm = fm;
    }

    public Line createLine(String name, boolean useByteStorage) {
        Line line = new Line(name);
        for (ChromosomeMap map : this.chromosomes) {
            line.initializeMap(map, useByteStorage);
        }
        this.lines.add(line);
        return line;
    }

    public ChromosomeMap getMapByIndex(int index) throws ArrayIndexOutOfBoundsException {
        return this.chromosomes.get(index);
    }

    public Line getLineByIndex(int index) throws ArrayIndexOutOfBoundsException {
        return this.lines.get(index);
    }

    public ChromosomeMap.Wrapper getMapByName(String mapName, boolean create) {
        for (int i = 0; i < this.chromosomes.size(); ++i) {
            if (!this.chromosomes.get(i).getName().equals(mapName)) continue;
            return new ChromosomeMap.Wrapper(this.chromosomes.get(i), i);
        }
        if (!create) {
            return null;
        }
        ChromosomeMap map = new ChromosomeMap(mapName);
        this.chromosomes.add(map);
        return new ChromosomeMap.Wrapper(map, this.chromosomes.size() - 1);
    }

    public int countChromosomeMaps() {
        return this.chromosomes.size();
    }

    public int countLines() {
        return this.lines.size();
    }

    public int countGenuineMarkers() {
        int count = 0;
        for (ChromosomeMap map : this.chromosomes) {
            if (map.isSpecialChromosome()) continue;
            count += map.countLoci();
        }
        return count;
    }

    public void orderMarkersWithinMaps() {
        for (ChromosomeMap map : this.chromosomes) {
            map.sort();
        }
    }

    public void createSuperChromosome(String chromosomeName) {
        boolean useByteStorage = true;
        if (this.lines.size() > 0) {
            useByteStorage = this.lines.get(0).useByteStorage();
        }
        ChromosomeMap allMap = new ChromosomeMap(chromosomeName);
        allMap.setSpecialChromosome(true);
        double mapOffset = 0.0;
        for (int i = 0; i < this.chromosomes.size(); ++i) {
            ChromosomeMap map = this.chromosomes.get(i);
            for (Marker marker : map) {
                double position = mapOffset + marker.getPosition();
                double realPosition = marker.getPosition();
                Marker m = new Marker(marker.getName(), position, realPosition);
                allMap.addMarker(m);
            }
            mapOffset += map.getLength();
            if (i >= this.chromosomes.size() - 1) continue;
            for (int d = 0; d < 5; ++d) {
                allMap.addMarker(new Marker(true, mapOffset));
            }
        }
        allMap.sort();
        int allMapIndex = this.chromosomes.size();
        for (Line line : this.lines) {
            line.initializeMap(allMap, useByteStorage);
            int loci = 0;
            for (int i = 0; i < this.chromosomes.size(); ++i) {
                ChromosomeMap map = this.chromosomes.get(i);
                int j = 0;
                int num = map.countLoci();
                while (j < num) {
                    line.setLoci(allMapIndex, loci, line.getState(i, j));
                    ++j;
                    ++loci;
                }
                if (i >= this.chromosomes.size() - 1) continue;
                int d = 0;
                while (d < 5) {
                    line.setLoci(allMapIndex, loci, 0);
                    ++d;
                    ++loci;
                }
            }
        }
        this.chromosomes.add(allMap);
    }
}

