/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import jhi.flapjack.analysis.AnalysisSet;
import jhi.flapjack.analysis.SimulateF1;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.StateTable;
import jhi.flapjack.data.pedigree.PedManager;
import jhi.flapjack.data.results.PedVerF1sResult;
import scri.commons.gui.SimpleJob;

public class PedVerF1sAnalysis
extends SimpleJob {
    private GTViewSet viewSet;
    private AnalysisSet as;
    private StateTable stateTable;
    private int parent1Index;
    private int parent2Index;
    private boolean simulateF1;
    private int f1Index;
    private boolean[] selectedChromosomes;
    private String name;
    private boolean excludeAdditionalParents;
    private int f1HetCount = 0;
    private int totalMarkerCount = 0;
    private double f1PercentCount = 0.0;

    public PedVerF1sAnalysis(GTViewSet viewSet, boolean[] selectedChromosomes, int parent1Index, int parent2Index, boolean simulateF1, int f1Index, boolean excludeAdditionalParents, String name) {
        this.viewSet = viewSet.createClone("", true);
        this.selectedChromosomes = selectedChromosomes;
        this.stateTable = viewSet.getDataSet().getStateTable();
        this.parent1Index = parent1Index;
        this.parent2Index = parent2Index;
        this.simulateF1 = simulateF1;
        this.f1Index = f1Index;
        this.excludeAdditionalParents = excludeAdditionalParents;
        this.name = name;
        this.setupAnalysis();
    }

    private void setupAnalysis() {
        if (this.simulateF1) {
            SimulateF1 f1Sim = new SimulateF1(this.viewSet, this.parent1Index, this.parent2Index);
            f1Sim.runJob(0);
            this.f1Index = f1Sim.getF1Index();
        }
        if (this.excludeAdditionalParents) {
            PedManager pedMan = this.viewSet.getDataSet().getPedManager();
            for (int i = this.viewSet.getLines().size() - 1; i >= 0; --i) {
                if (i == this.parent1Index || i == this.parent2Index || i == this.f1Index || !pedMan.isParent(this.viewSet.getLines().get(i))) continue;
                this.viewSet.getLines().remove(i);
                if (i < this.parent1Index) {
                    --this.parent1Index;
                }
                if (i < this.parent2Index) {
                    --this.parent2Index;
                }
                if (i >= this.f1Index) continue;
                --this.f1Index;
            }
        }
    }

    public void runJob(int index) {
        this.as = new AnalysisSet(this.viewSet).withViews(this.selectedChromosomes).withSelectedLines().withSelectedMarkers();
        this.calculateExpectedF1Stats();
        for (int l = 0; l < this.as.lineCount(); ++l) {
            this.calculateStatsForLine(l);
        }
        this.prepareForVisualization();
    }

    private PedVerF1sResult calculateStatsForLine(int lineIndex) {
        LineInfo lineInfo = this.as.getLine(lineIndex);
        PedVerF1sResult lineStat = new PedVerF1sResult();
        lineInfo.getResults().setPedVerF1sResult(lineStat);
        lineInfo.getResults().setName(this.name);
        int foundMarkers = this.usableMarkerCount(lineIndex);
        int hetMarkers = this.hetMarkerCount(lineIndex);
        int p1Contained = this.containedInLine(lineIndex, this.parent1Index);
        int p2Contained = this.containedInLine(lineIndex, this.parent2Index);
        int matchesExpF1 = this.matchesExpF1(lineIndex);
        int missingCount = this.countMissingAlleles(lineIndex);
        lineStat.setMarkerCount(foundMarkers);
        lineStat.setPercentMissing((double)missingCount / (double)this.totalMarkerCount * 100.0);
        lineStat.setHeterozygousCount(hetMarkers);
        lineStat.setPercentHeterozygous((double)hetMarkers / (double)foundMarkers * 100.0);
        lineStat.setPercentDeviationFromExpected(this.f1PercentCount - (double)hetMarkers / (double)foundMarkers * 100.0);
        lineStat.setCountP1Contained(p1Contained);
        lineStat.setPercentP1Contained((double)p1Contained / (double)foundMarkers * 100.0);
        lineStat.setCountP2Contained(p2Contained);
        lineStat.setPercentP2Contained((double)p2Contained / (double)foundMarkers * 100.0);
        lineStat.setCountAlleleMatchExpected(matchesExpF1);
        lineStat.setPercentAlleleMatchExpected((double)matchesExpF1 / (double)foundMarkers * 100.0);
        return lineStat;
    }

    private void calculateExpectedF1Stats() {
        for (int c = 0; c < this.as.viewCount(); ++c) {
            for (int m = 0; m < this.as.markerCount(c); ++m) {
                if (!this.isUsableMarker(c, this.f1Index, m)) continue;
                ++this.totalMarkerCount;
                int stateCode = this.as.getState(c, this.f1Index, m);
                if (!this.stateTable.isHet(stateCode)) continue;
                ++this.f1HetCount;
            }
        }
        this.f1PercentCount = (double)this.f1HetCount / (double)this.totalMarkerCount * 100.0;
    }

    private boolean isUsableMarker(int chr, int line, int marker) {
        return this.as.getState(chr, line, marker) != 0 && this.as.getState(chr, this.parent1Index, marker) != 0 && this.as.getState(chr, this.parent2Index, marker) != 0 && this.as.getState(chr, this.f1Index, marker) != 0 && this.stateTable.isHom(this.as.getState(chr, this.parent1Index, marker)) && this.stateTable.isHom(this.as.getState(chr, this.parent2Index, marker));
    }

    private int usableMarkerCount(int lineIndex) {
        int foundMarkers = 0;
        for (int c = 0; c < this.as.viewCount(); ++c) {
            for (int m = 0; m < this.as.markerCount(c); ++m) {
                if (!this.isUsableMarker(c, lineIndex, m)) continue;
                ++foundMarkers;
            }
        }
        return foundMarkers;
    }

    private int countMissingAlleles(int lineIndex) {
        int missingCount = 0;
        for (int c = 0; c < this.as.viewCount(); ++c) {
            for (int m = 0; m < this.as.markerCount(c); ++m) {
                if (this.as.getState(c, lineIndex, m) != 0 || this.as.getState(c, this.parent1Index, m) == 0 || this.as.getState(c, this.parent2Index, m) == 0 || this.as.getState(c, this.f1Index, m) == 0 || this.stateTable.isHet(this.as.getState(c, this.parent1Index, m)) || this.stateTable.isHet(this.as.getState(c, this.parent2Index, m))) continue;
                ++missingCount;
            }
        }
        return missingCount;
    }

    private int hetMarkerCount(int lineIndex) {
        int hetMarkers = 0;
        for (int c = 0; c < this.as.viewCount(); ++c) {
            for (int m = 0; m < this.as.markerCount(c); ++m) {
                if (!this.isUsableMarker(c, lineIndex, m) || !this.stateTable.isHet(this.as.getState(c, lineIndex, m))) continue;
                ++hetMarkers;
            }
        }
        return hetMarkers;
    }

    private int containedInLine(int line, int comparisonLine) {
        int contained = 0;
        for (int c = 0; c < this.as.viewCount(); ++c) {
            for (int m = 0; m < this.as.markerCount(c); ++m) {
                if (!this.isUsableMarker(c, line, m)) continue;
                AlleleState testState = this.stateTable.getAlleleState(this.as.getState(c, comparisonLine, m));
                AlleleState currState = this.stateTable.getAlleleState(this.as.getState(c, line, m));
                if (!currState.matchesAnyAllele(testState)) continue;
                ++contained;
            }
        }
        return contained;
    }

    private int matchesExpF1(int lineIndex) {
        int matchesExpF1 = 0;
        for (int c = 0; c < this.as.viewCount(); ++c) {
            for (int m = 0; m < this.as.markerCount(c); ++m) {
                if (!this.isUsableMarker(c, lineIndex, m)) continue;
                AlleleState testState = this.stateTable.getAlleleState(this.as.getState(c, this.f1Index, m));
                AlleleState currState = this.stateTable.getAlleleState(this.as.getState(c, lineIndex, m));
                if (!currState.matches(testState)) continue;
                ++matchesExpF1;
            }
        }
        return matchesExpF1;
    }

    private void prepareForVisualization() {
        this.prepareParentsForVisualization();
        this.changeColourScheme();
        this.addViewSetToDataSet();
    }

    private void prepareParentsForVisualization() {
        LineInfo p1 = this.viewSet.getLines().get(this.parent1Index);
        LineInfo p2 = this.viewSet.getLines().get(this.parent2Index);
        LineInfo f1 = this.viewSet.getLines().get(this.f1Index);
        p1.getResults().setSortToTop(true);
        p2.getResults().setSortToTop(true);
        f1.getResults().setSortToTop(true);
        this.viewSet.getLines().remove(p1);
        this.viewSet.getLines().remove(p2);
        this.viewSet.getLines().remove(f1);
        this.viewSet.getLines().add(0, p1);
        this.viewSet.getLines().add(1, p2);
        this.viewSet.getLines().add(2, f1);
        this.parent1Index = 0;
        this.parent2Index = 1;
        this.f1Index = 2;
    }

    private void changeColourScheme() {
        this.viewSet.setColorScheme(12);
        this.viewSet.setComparisonLineIndex(this.f1Index);
        this.viewSet.setComparisonLine(this.viewSet.getLines().get(this.f1Index).getLine());
    }

    private void addViewSetToDataSet() {
        DataSet dataSet = this.viewSet.getDataSet();
        this.viewSet.setName(this.name);
        dataSet.getViewSets().add(this.viewSet);
    }

    public GTViewSet getViewSet() {
        return this.viewSet;
    }
}

