/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.args4j.spi;

import ch.systemsx.cisd.args4j.CmdLineException;
import ch.systemsx.cisd.args4j.ExampleMode;
import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.args4j.spi.Parameters;
import java.util.ResourceBundle;

public abstract class OptionHandler {
    private final Option option;
    private final String name;
    private final String longName;

    protected OptionHandler(Option option) {
        this.option = option;
        this.name = OptionHandler.getCanonicalShortName(option);
        this.longName = OptionHandler.getCanonicalLongName(option);
    }

    private static String getCanonicalShortName(Option option) {
        String name = option.name();
        if (name.length() == 0) {
            return "";
        }
        int nonDashOffset = OptionHandler.findFirstNoneDash(name);
        return "-" + name.substring(nonDashOffset);
    }

    private static String getCanonicalLongName(Option option) {
        String name = option.longName();
        if (name.length() == 0) {
            return "";
        }
        int nonDashOffset = OptionHandler.findFirstNoneDash(name);
        return "--" + name.substring(nonDashOffset);
    }

    private static int findFirstNoneDash(String s) {
        int len = s.length();
        int idx = 0;
        while (idx < len && s.charAt(idx) == '-') {
            ++idx;
        }
        return idx;
    }

    public abstract int parseArguments(Parameters var1) throws CmdLineException;

    public abstract void set(String var1) throws CmdLineException;

    public abstract String getDefaultMetaVariable();

    public final String getName() {
        return this.name;
    }

    public final String getLongName() {
        return this.longName;
    }

    public final boolean isRequired() {
        return this.option.required();
    }

    public final String getUsage() {
        return this.option.usage();
    }

    public final boolean printForExample(ExampleMode mode) {
        return mode.print(this.option) && !this.option.skipForExample();
    }

    public final String getMetaVariable(ResourceBundle rb) {
        String localized;
        String token = this.option.metaVar();
        if (token.length() == 0) {
            token = this.getDefaultMetaVariable();
        }
        if (token == null) {
            return null;
        }
        if (rb != null && (localized = rb.getString(token)) != null) {
            token = localized;
        }
        return token;
    }
}

