/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.args4j;

import ch.systemsx.cisd.args4j.CmdLineException;
import ch.systemsx.cisd.args4j.Messages;
import ch.systemsx.cisd.args4j.spi.Parameters;

class CmdLineParameters
extends Parameters {
    private final String[] args;
    private int pos;

    CmdLineParameters(String[] args) {
        this.args = args;
        this.pos = 0;
    }

    boolean hasMore() {
        return this.pos < this.args.length;
    }

    private String getCurrentToken() {
        return this.args[this.pos];
    }

    void proceed(int n) {
        this.pos += n;
    }

    public String getOptionName() {
        return this.getCurrentToken();
    }

    public String getParameter(int idx) throws CmdLineException {
        if (this.pos + idx + 1 >= this.args.length) {
            throw new CmdLineException(Messages.MISSING_OPERAND.format(this.getOptionName()));
        }
        return this.args[this.pos + idx + 1];
    }

    public int getParameterCount() {
        return this.args.length - (this.pos + 1);
    }
}

