/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.header;

import java.io.IOException;
import org.restlet.data.Cookie;
import org.restlet.data.Parameter;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.header.HeaderUtils;

public class CookieReader
extends HeaderReader<Cookie> {
    private static final String NAME_DOMAIN = "$Domain";
    private static final String NAME_PATH = "$Path";
    private static final String NAME_VERSION = "$Version";
    private volatile int globalVersion = -1;

    public static Cookie read(String cookie) throws IllegalArgumentException {
        CookieReader cr = new CookieReader(cookie);
        try {
            return cr.readValue();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read the cookie", e);
        }
    }

    public CookieReader(String header) {
        super(header);
    }

    private Parameter readPair(boolean readAttribute) throws IOException {
        Parameter result = null;
        boolean readingName = true;
        boolean readingValue = false;
        StringBuilder nameBuffer = new StringBuilder();
        StringBuilder valueBuffer = new StringBuilder();
        int nextChar = 0;
        while (result == null && nextChar != -1) {
            nextChar = this.read();
            if (readingName) {
                if (HeaderUtils.isSpace(nextChar) && nameBuffer.length() == 0) continue;
                if (nextChar == -1 || nextChar == 59 || nextChar == 44) {
                    if (nameBuffer.length() > 0) {
                        result = Parameter.create(nameBuffer, null);
                        continue;
                    }
                    if (nextChar == -1) continue;
                    throw new IOException("Empty cookie name detected. Please check your cookies");
                }
                if (nextChar == 61) {
                    readingName = false;
                    readingValue = true;
                    continue;
                }
                if (HeaderUtils.isTokenChar(nextChar) || this.globalVersion < 1) {
                    if (readAttribute && nextChar != 36 && nameBuffer.length() == 0) {
                        this.unread();
                        nextChar = -1;
                        continue;
                    }
                    nameBuffer.append((char)nextChar);
                    continue;
                }
                throw new IOException("Separator and control characters are not allowed within a token. Please check your cookie header");
            }
            if (!readingValue || HeaderUtils.isSpace(nextChar) && valueBuffer.length() == 0) continue;
            if (nextChar == -1 || nextChar == 59) {
                result = Parameter.create(nameBuffer, valueBuffer);
                continue;
            }
            if (nextChar == 34 && valueBuffer.length() == 0) {
                this.unread();
                valueBuffer.append(this.readQuotedString());
                continue;
            }
            if (HeaderUtils.isTokenChar(nextChar) || this.globalVersion < 1) {
                valueBuffer.append((char)nextChar);
                continue;
            }
            throw new IOException("Separator and control characters are not allowed within a token. Please check your cookie header");
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Cookie readValue() throws IOException {
        Cookie result = null;
        Parameter pair = this.readPair(false);
        if (pair != null && this.globalVersion == -1) {
            if (NAME_VERSION.equalsIgnoreCase(pair.getName())) {
                if (pair.getValue() == null) throw new IOException("Empty cookies version attribute detected. Please check your cookie header");
                this.globalVersion = Integer.parseInt(pair.getValue());
            } else {
                this.globalVersion = 0;
            }
        }
        while (pair != null && (pair.getName().isEmpty() || pair.getName().charAt(0) == '$')) {
            pair = this.readPair(false);
        }
        if (pair != null) {
            result = new Cookie(this.globalVersion, pair.getName(), pair.getValue());
            pair = this.readPair(true);
        }
        while (pair != null && (pair.getName().isEmpty() || pair.getName().charAt(0) == '$')) {
            if (pair.getName().equalsIgnoreCase(NAME_PATH)) {
                result.setPath(pair.getValue());
            } else if (pair.getName().equalsIgnoreCase(NAME_DOMAIN)) {
                result.setDomain(pair.getValue());
            }
            pair = this.readPair(true);
        }
        return result;
    }
}

