/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.cmd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class Transpose {
    private static final int CACHELINES = 5000;
    private List<String[]> data = new ArrayList<String[]>(5000);
    private int maxCols = 0;
    private List<File> cache = new ArrayList<File>();
    private static File folder;

    public static void main(String[] args) throws IOException {
        long s = System.currentTimeMillis();
        folder = Files.createTempDirectory("transpose", new FileAttribute[0]).toFile();
        folder.deleteOnExit();
        Transpose t = new Transpose();
        System.out.println("Reading input...");
        t.readData(args[0]);
        System.out.println("Read time: " + (System.currentTimeMillis() - s) + "ms");
        System.out.println("Transposing output...");
        t.writeData(args[1]);
        long e = System.currentTimeMillis();
        System.out.println("Time: " + (e - s) + "ms");
    }

    private void readData(String filename) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(filename));){
            String str;
            int line = 0;
            long s = System.currentTimeMillis();
            while ((str = in.readLine()) != null && str.length() > 0) {
                this.data.add(str.split("\t", -1));
                ++line;
                if (this.data.size() != 5000) continue;
                System.out.println(line + " - read:  " + (System.currentTimeMillis() - s) + "ms");
                s = System.currentTimeMillis();
                this.writeCache();
                System.out.println(line + " - cache: " + (System.currentTimeMillis() - s) + "ms");
                s = System.currentTimeMillis();
            }
            this.writeCache();
        }
    }

    private void writeCache() throws IOException {
        int i;
        int cols;
        this.maxCols = cols = this.data.get(0).length;
        if (this.cache.size() == 0) {
            for (i = 0; i < cols; ++i) {
                File file = new File(folder, "_transpose_temp_" + i);
                file.delete();
                this.cache.add(file);
            }
        }
        for (i = 0; i < cols; ++i) {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.cache.get(i), true));
            for (String[] aData : this.data) {
                try {
                    out.write(aData[i] + "\t");
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
            out.close();
        }
        this.data.clear();
    }

    private void writeData(String filename) throws IOException {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(filename));){
            for (int i = 0; i < this.maxCols; ++i) {
                BufferedReader in = new BufferedReader(new FileReader(this.cache.get(i)));
                String line = in.readLine();
                out.write(line.substring(0, line.length() - 1));
                if (i < this.maxCols - 1) {
                    out.newLine();
                }
                in.close();
                this.cache.get(i).delete();
            }
        }
    }
}

