/*
 * Decompiled with CFR 0.152.
 */
package jhi.gobii;

public class Parent {
    public static final String RP = "RP";
    public static final String DP = "DP";
    public static final String NA = "N/A";
    private final String germplasmName;
    private final String type;

    public Parent(String germplasmName, String type) throws Exception {
        this.germplasmName = germplasmName;
        this.type = this.parseParentType(type);
    }

    private String parseParentType(String type) throws Exception {
        if (type.isEmpty()) {
            type = NA;
        }
        switch (type.toUpperCase()) {
            case "RP": {
                return RP;
            }
            case "DP": {
                return DP;
            }
            case "N/A": {
                return NA;
            }
        }
        throw new Exception("Unknown parent type found");
    }

    public String getGermplasmName() {
        return this.germplasmName;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parent parent = (Parent)o;
        if (!this.germplasmName.equals(parent.germplasmName)) {
            return false;
        }
        return this.type.equals(parent.type);
    }

    public int hashCode() {
        int result = this.germplasmName.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return "Parent{germplasmName='" + this.germplasmName + '\'' + ", type='" + this.type + '\'' + '}';
    }
}

