/*
 * Decompiled with CFR 0.152.
 */
package org.castor.core.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class IdentitySet
implements Set {
    private static final int DEFAULT_CAPACITY = 17;
    private static final float DEFAULT_LOAD = 0.75f;
    private static final int DEFAULT_ENTRIES = 12;
    private static final int DEFAULT_INCREMENT = 2;
    private static final int FIRST_PRIME_TO_CHECK = 3;
    private int _capacity;
    private int _maximum;
    private Entry[] _buckets;
    private int _entries = 0;

    public IdentitySet() {
        this._capacity = 17;
        this._maximum = 12;
        this._buckets = new Entry[17];
    }

    public IdentitySet(int capacity) {
        this._capacity = capacity;
        this._maximum = (int)((float)capacity * 0.75f);
        this._buckets = new Entry[capacity];
    }

    @Override
    public void clear() {
        this._capacity = 17;
        this._maximum = 12;
        this._buckets = new Entry[17];
        this._entries = 0;
    }

    @Override
    public int size() {
        return this._entries;
    }

    @Override
    public boolean isEmpty() {
        return this._entries == 0;
    }

    @Override
    public boolean add(Object key) {
        int hash = System.identityHashCode(key);
        int index = hash % this._capacity;
        if (index < 0) {
            index = -index;
        }
        Entry prev = null;
        for (Entry entry = this._buckets[index]; entry != null; entry = entry.getNext()) {
            if (entry.getKey() == key) {
                return false;
            }
            prev = entry;
        }
        if (prev == null) {
            this._buckets[index] = new Entry(key, hash);
        } else {
            prev.setNext(new Entry(key, hash));
        }
        ++this._entries;
        if (this._entries > this._maximum) {
            this.rehash();
        }
        return true;
    }

    private void rehash() {
        long nextCapacity = this._capacity * 2;
        if (nextCapacity > Integer.MAX_VALUE) {
            return;
        }
        if ((nextCapacity = this.nextPrime(nextCapacity)) > Integer.MAX_VALUE) {
            return;
        }
        int newCapacity = (int)nextCapacity;
        Entry[] newBuckets = new Entry[newCapacity];
        Entry entry = null;
        Entry temp = null;
        Entry next = null;
        int newIndex = 0;
        for (int index = 0; index < this._capacity; ++index) {
            entry = this._buckets[index];
            while (entry != null) {
                next = entry.getNext();
                newIndex = entry.getHash() % newCapacity;
                if (newIndex < 0) {
                    newIndex = -newIndex;
                }
                if ((temp = newBuckets[newIndex]) == null) {
                    entry.setNext(null);
                } else {
                    entry.setNext(temp);
                }
                newBuckets[newIndex] = entry;
                entry = next;
            }
        }
        this._capacity = newCapacity;
        this._maximum = (int)((float)newCapacity * 0.75f);
        this._buckets = newBuckets;
    }

    private long nextPrime(long minimum) {
        long candidate = (minimum + 1L) / 2L * 2L + 1L;
        while (!this.isPrime(candidate)) {
            candidate += 2L;
        }
        return candidate;
    }

    private boolean isPrime(long candidate) {
        if (candidate / 2L * 2L == candidate) {
            return false;
        }
        long stop = candidate / 2L;
        for (long i = 3L; i < stop; i += 2L) {
            if (candidate / i * i != candidate) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object key) {
        int hash = System.identityHashCode(key);
        int index = hash % this._capacity;
        if (index < 0) {
            index = -index;
        }
        for (Entry entry = this._buckets[index]; entry != null; entry = entry.getNext()) {
            if (entry.getKey() != key) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object key) {
        int hash = System.identityHashCode(key);
        int index = hash % this._capacity;
        if (index < 0) {
            index = -index;
        }
        Entry prev = null;
        for (Entry entry = this._buckets[index]; entry != null; entry = entry.getNext()) {
            if (entry.getKey() == key) {
                if (prev == null) {
                    this._buckets[index] = entry.getNext();
                } else {
                    prev.setNext(entry.getNext());
                }
                --this._entries;
                return true;
            }
            prev = entry;
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        return new IdentityIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this._entries];
        int j = 0;
        for (int i = 0; i < this._capacity; ++i) {
            for (Entry entry = this._buckets[i]; entry != null; entry = entry.getNext()) {
                result[j++] = entry.getKey();
            }
        }
        return result;
    }

    @Override
    public Object[] toArray(Object[] a) {
        Object[] result = a;
        if (result.length < this._entries) {
            result = (Object[])Array.newInstance(result.getClass().getComponentType(), this._entries);
        }
        int j = 0;
        for (int i = 0; i < this._capacity; ++i) {
            for (Entry entry = this._buckets[i]; entry != null; entry = entry.getNext()) {
                result[j++] = entry.getKey();
            }
        }
        while (j < result.length) {
            result[j++] = null;
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    private class IdentityIterator
    implements Iterator {
        private int _index = 0;
        private Entry _next = IdentitySet.access$000(IdentitySet.this)[0];

        public IdentityIterator() {
            if (IdentitySet.this._entries > 0) {
                while (this._next == null && ++this._index < IdentitySet.this._capacity) {
                    this._next = IdentitySet.this._buckets[this._index];
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        public Object next() {
            Entry entry = this._next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            this._next = entry.getNext();
            while (this._next == null && ++this._index < IdentitySet.this._capacity) {
                this._next = IdentitySet.this._buckets[this._index];
            }
            return entry.getKey();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public final class Entry {
        private Object _key;
        private int _hash;
        private Entry _next = null;

        public Entry(Object key, int hash) {
            this._key = key;
            this._hash = hash;
        }

        public Object getKey() {
            return this._key;
        }

        public int getHash() {
            return this._hash;
        }

        public void setNext(Entry next) {
            this._next = next;
        }

        public Entry getNext() {
            return this._next;
        }
    }
}

