/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.cmd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jhi.flapjack.io.cmd.CmdOptions;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;

public class HapMapToFJTabbedConverter {
    private static final String HAPMAP_HEADER_ID = "rs";
    private File hapMap;
    private File map;
    private File genotypes;
    private List<Marker> markers;
    private Line[] lines;
    private String separator;
    private static final String TAB_SEPARATOR = "\t";
    private static final String SPACE_SEPARATOR = "\\s+";
    private Map<String, String> alleleHash = new HashMap<String, String>();

    public static void main(String[] args) {
        CmdOptions options = new CmdOptions().withAdvancedOptions().withGenotypeFile(true).withMapFile(true).addRequiredOption("h", "hapmap", true, "FILE", "Required input file").addRequiredOption("s", "separator", true, "ARG", "Required argument s|t");
        try {
            String separator;
            CommandLine line = new DefaultParser().parse((Options)options, args);
            File map = options.getMapFile(line);
            File genotypes = options.getGenotypeFile(line);
            File hapMap = new File(line.getOptionValue("hapmap"));
            switch (separator = line.getOptionValue("separator")) {
                case "s": {
                    separator = SPACE_SEPARATOR;
                    break;
                }
                case "t": {
                    separator = TAB_SEPARATOR;
                    break;
                }
                default: {
                    options.printHelp("HapMapToFJTabbedConverter");
                    System.exit(1);
                }
            }
            HapMapToFJTabbedConverter toFlapjack = new HapMapToFJTabbedConverter(hapMap, map, genotypes, separator);
            toFlapjack.convert();
            System.exit(0);
        }
        catch (Exception e) {
            options.printHelp("HapMapToFJTabbedConverter");
            System.exit(1);
        }
    }

    public HapMapToFJTabbedConverter(File hapMap, File map, File genoytpyes, String separator) {
        this.hapMap = hapMap;
        this.map = map;
        this.genotypes = genoytpyes;
        this.separator = separator;
        this.initAlleleMap();
    }

    private void initAlleleMap() {
        this.alleleHash.put("A", "A");
        this.alleleHash.put("C", "C");
        this.alleleHash.put("G", "G");
        this.alleleHash.put("T", "T");
        this.alleleHash.put("N", "N");
        this.alleleHash.put("Y", "C/T");
        this.alleleHash.put("R", "A/G");
        this.alleleHash.put("W", "A/T");
        this.alleleHash.put("S", "G/C");
        this.alleleHash.put("K", "T/G");
        this.alleleHash.put("M", "C/A");
    }

    public void convert() {
        this.processHapMapFile();
        this.outputMapFile();
        this.outputGenotypeFile();
    }

    private void processHapMapFile() {
        System.out.println("Reading HapMap file");
        this.markers = new ArrayList<Marker>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.hapMap));){
            String line;
            int i = 0;
            while ((line = reader.readLine()) != null) {
                String[] cols = line.split(this.separator);
                String[] genos = Arrays.copyOfRange(cols, 11, cols.length);
                if (line.startsWith(HAPMAP_HEADER_ID)) {
                    this.processHeaderLine(genos);
                } else {
                    this.createMarker(cols[0], cols[2], cols[3]);
                    this.addSnpCallsToLines(genos);
                }
                if (++i % 100 != 0) continue;
                System.out.println("Processed: " + i + " lines");
            }
            System.out.println("Finished reading HapMap file");
            System.out.println("Total lines processed = " + i);
            System.out.println("Found " + this.markers.size() + " markers and " + this.lines.length + " accessions / lines");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void processHeaderLine(String[] lineNames) {
        this.lines = new Line[lineNames.length];
        for (int i = 0; i < lineNames.length; ++i) {
            this.lines[i] = new Line(lineNames[i]);
        }
    }

    private void createMarker(String name, String chromosome, String position) {
        Marker marker = new Marker(name, chromosome, position);
        this.markers.add(marker);
    }

    private void addSnpCallsToLines(String[] snpCalls) {
        for (int i = 0; i < snpCalls.length; ++i) {
            this.lines[i].addSnpCall(this.convertAndCollapseSnpCall(snpCalls[i]));
        }
    }

    private String convertAndCollapseSnpCall(String call) {
        String second;
        if (call.length() == 1) {
            return this.alleleHash.getOrDefault(call, "-");
        }
        String first = this.alleleHash.getOrDefault(call.substring(0, 1), "-");
        if (first.equals(second = this.alleleHash.getOrDefault(call.substring(1, 2), "-"))) {
            return first.equals("N") ? "-" : first;
        }
        return first + "/" + second;
    }

    private void outputMapFile() {
        System.out.println();
        System.out.println("Outputting map file: " + this.map.getAbsolutePath());
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(this.map)));){
            writer.println("# fjFile = MAP");
            this.markers.forEach(marker -> writer.println(marker.name() + TAB_SEPARATOR + marker.chromosome() + TAB_SEPARATOR + marker.position()));
            System.out.println("Finished outputting map file: " + this.map.getAbsolutePath());
            System.out.println("Wrote " + this.markers.size() + " markers to file");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void outputGenotypeFile() {
        System.out.println();
        System.out.println("Outputting genotype file: " + this.genotypes.getAbsolutePath());
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(this.genotypes)));){
            writer.println("# fjFile = GENOTYPE");
            this.markers.forEach(marker -> writer.print(TAB_SEPARATOR + marker.name()));
            writer.println();
            Stream.of(this.lines).forEach(line -> writer.println(line.name() + TAB_SEPARATOR + line.snpCalls().stream().collect(Collectors.joining(TAB_SEPARATOR))));
            System.out.println("Finished outputting genotype file: " + this.genotypes.getAbsolutePath());
            System.out.println("Wrote " + this.lines.length + " accessions / lines to file");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    class Line {
        private String name;
        private List<String> snpCalls;

        public Line(String name) {
            this.name = name;
            this.snpCalls = new ArrayList<String>();
        }

        public void addSnpCall(String call) {
            this.snpCalls.add(call);
        }

        public String name() {
            return this.name;
        }

        public List<String> snpCalls() {
            return this.snpCalls;
        }
    }

    class Marker {
        private String name;
        private String chromosome;
        private String position;

        public Marker(String name, String chromosome, String position) {
            this.name = name;
            this.chromosome = chromosome;
            this.position = position;
        }

        public String name() {
            return this.name;
        }

        public String chromosome() {
            return this.chromosome;
        }

        public String position() {
            return this.position;
        }
    }
}

