/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import java.awt.Color;
import java.util.ArrayList;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.GTView;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.colors.ColorScheme;
import jhi.flapjack.gui.visualization.colors.ColorState;
import jhi.flapjack.gui.visualization.colors.HeterozygeousColorState;
import jhi.flapjack.gui.visualization.colors.HomozygousColorState;
import jhi.flapjack.gui.visualization.colors.SimpleColorState;

abstract class SimilarityColorScheme
extends ColorScheme {
    protected ArrayList<ColorState> compStates = new ArrayList();
    protected ArrayList<ColorState> mtchStatesY = new ArrayList();
    protected ArrayList<ColorState> mtchStatesN = new ArrayList();
    protected ArrayList<ColorState> het1States = new ArrayList();
    protected ArrayList<ColorState> het2States = new ArrayList();
    protected ArrayList<ColorState> gsStates = new ArrayList();
    protected int[][] lookupTable;

    public SimilarityColorScheme() {
    }

    public SimilarityColorScheme(GTView view, int w, int h) {
        super(view);
        Color sHz = Prefs.visColorNucleotideHZ;
        Color drk = Prefs.visColorSimStateMatchDark;
        Color s1 = Prefs.visColorSimStateMatch;
        Color s2 = Prefs.visColorSimStateNoMatch;
        Color gsC = Prefs.visColorSimStateMissing;
        for (int i = 0; i < this.stateTable.size(); ++i) {
            ColorState comp;
            ColorState mtchY;
            ColorState mtchN;
            ColorState het1;
            ColorState het2;
            ColorState gs;
            AlleleState state = this.stateTable.getAlleleState(i);
            if (state.isUnknown()) {
                het2 = gs = new SimpleColorState(state, Prefs.visColorBackground, w, h);
                het1 = gs;
                mtchN = gs;
                mtchY = gs;
                comp = gs;
            } else if (state.isHomozygous()) {
                comp = new HomozygousColorState(state, drk, w, h);
                mtchY = new HomozygousColorState(state, s1, w, h);
                mtchN = new HomozygousColorState(state, s2, w, h);
                het1 = null;
                het2 = null;
                gs = new HomozygousColorState(state, gsC, w, h);
            } else {
                comp = new HeterozygeousColorState(state, sHz, drk, drk, w, h);
                mtchY = new HeterozygeousColorState(state, sHz, s1, s1, w, h);
                mtchN = new HeterozygeousColorState(state, sHz, s2, s2, w, h);
                het1 = new HeterozygeousColorState(state, sHz, s1, s2, w, h);
                het2 = new HeterozygeousColorState(state, sHz, s2, s1, w, h);
                gs = new HeterozygeousColorState(state, sHz, gsC, gsC, w, h);
            }
            this.compStates.add(comp);
            this.mtchStatesY.add(mtchY);
            this.mtchStatesN.add(mtchN);
            this.het1States.add(het1);
            this.het2States.add(het2);
            this.gsStates.add(gs);
        }
        this.createLookupTable();
    }

    @Override
    public void setColorSummaries(ArrayList<ColorScheme.ColorSummary> colors) {
        Prefs.visColorSimStateMatchDark = colors.get((int)0).color;
        Prefs.visColorSimStateMatch = colors.get((int)1).color;
        Prefs.visColorSimStateNoMatch = colors.get((int)2).color;
        Prefs.visColorSimStateMissing = colors.get((int)3).color;
    }

    private void createLookupTable() {
        int count = this.stateTable.size();
        this.lookupTable = new int[count][count];
        for (int i = 0; i < count; ++i) {
            for (int j = 0; j < count; ++j) {
                this.lookupTable[i][j] = 2;
                if (i == j) {
                    this.lookupTable[i][j] = 1;
                    continue;
                }
                AlleleState ai = this.stateTable.getAlleleState(i);
                AlleleState aj = this.stateTable.getAlleleState(j);
                if (i == 0 || j == 0) {
                    this.lookupTable[i][j] = 5;
                    continue;
                }
                if (ai.isHomozygous() && !aj.isHomozygous()) {
                    if (!ai.getState(0).equals(aj.getState(0)) && !ai.getState(0).equals(aj.getState(1))) continue;
                    this.lookupTable[i][j] = 1;
                    continue;
                }
                if (!ai.isHomozygous() && aj.isHomozygous()) {
                    if (ai.getState(0).equals(aj.getState(0))) {
                        this.lookupTable[i][j] = 3;
                        continue;
                    }
                    if (!ai.getState(1).equals(aj.getState(0))) continue;
                    this.lookupTable[i][j] = 4;
                    continue;
                }
                if (ai.isHomozygous() || aj.isHomozygous()) continue;
                if (ai.matches(aj)) {
                    this.lookupTable[i][j] = 1;
                    continue;
                }
                if (ai.getState(0).equals(aj.getState(0)) || ai.getState(0).equals(aj.getState(1))) {
                    this.lookupTable[i][j] = 3;
                    continue;
                }
                if (!ai.getState(1).equals(aj.getState(0)) && !ai.getState(1).equals(aj.getState(1))) continue;
                this.lookupTable[i][j] = 4;
            }
        }
    }
}

