/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import jhi.flapjack.data.AlleleState;

public abstract class ColorState {
    protected AlleleState state;
    protected Color color;
    protected BufferedImage image;
    protected BufferedImage imageUnderQTL;
    protected BufferedImage unSelImage;
    protected BufferedImage unSelImageUnderQTL;
    protected int w;
    protected int h;
    protected static int alpha = 200;

    ColorState(AlleleState state, Color c, int w, int h) {
        this.state = state;
        this.color = c;
        this.w = w;
        this.h = h;
    }

    protected void createUnselectedImage(int w, int h) {
        this.unSelImage = new BufferedImage(w, h, 1);
        Graphics2D g = this.unSelImage.createGraphics();
        g.drawImage((Image)this.image, 0, 0, null);
        g.setPaint(new Color(255, 255, 255, 200));
        g.fillRect(0, 0, w, h);
        g.dispose();
        this.unSelImageUnderQTL = new BufferedImage(w, h, 1);
        g = this.unSelImageUnderQTL.createGraphics();
        g.drawImage((Image)this.imageUnderQTL, 0, 0, null);
        g.setPaint(new Color(255, 255, 255, 200));
        g.fillRect(0, 0, w, h);
        g.dispose();
    }

    public BufferedImage getImage(boolean underQTL) {
        return underQTL ? this.imageUnderQTL : this.image;
    }

    public BufferedImage getUnselectedImage(boolean underQTL) {
        return underQTL ? this.unSelImageUnderQTL : this.unSelImage;
    }

    public Color getColor() {
        return this.color;
    }

    public static void setAlpha(int newAlpha) {
        alpha = newAlpha;
    }
}

