/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.traits;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.dialog.TraitColorsDialog;
import jhi.flapjack.gui.table.LineDataTable;
import jhi.flapjack.gui.table.LineDataTableModel;
import jhi.flapjack.gui.traits.TraitsPanelNB;
import jhi.flapjack.gui.traits.TraitsTableModel;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;

public class TraitsPanel
extends JPanel
implements ActionListener {
    private DataSet dataSet;
    private LineDataTable table;
    private TraitsTableModel model;
    private TraitsPanelNB controls;

    public TraitsPanel(DataSet dataSet) {
        this.dataSet = dataSet;
        this.controls = new TraitsPanelNB(dataSet);
        this.controls.bImport.addActionListener(this);
        this.controls.bExport.addActionListener(this);
        this.controls.bRemove.addActionListener(this);
        this.controls.bColors.addActionListener(this);
        this.table = (LineDataTable)this.controls.table;
        this.table.autoResize(false, true);
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, 0));
        this.add(this.controls);
        this.updateModel();
    }

    public LineDataTableModel getModel() {
        return this.model;
    }

    public void updateModel() {
        this.model = new TraitsTableModel(this.dataSet);
        this.table.setModel(this.model);
        this.controls.statusLabel.setText(RB.format((String)"gui.traits.TraitsPanel.traitCount", (Object[])new Object[]{this.table.getColumnCount() - 1}));
        this.controls.bExport.setEnabled(this.table.getColumnCount() - 1 > 0);
        this.controls.bRemove.setEnabled(this.table.getColumnCount() - 1 > 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.controls.bImport) {
            Flapjack.winMain.mFile.fileImport(1);
        } else if (e.getSource() == this.controls.bExport) {
            Flapjack.winMain.mData.dataExportTraits();
        } else if (e.getSource() == this.controls.bRemove) {
            String msg = RB.getString((String)"gui.traits.TraitsPanel.removeMsg");
            String[] options = new String[]{RB.getString((String)"gui.traits.TraitsPanel.remove"), RB.getString((String)"gui.text.cancel")};
            int response = TaskDialog.show((String)msg, (int)3, (int)1, (String[])options);
            if (response == 0) {
                this.removeAllTraits();
            }
        } else if (e.getSource() == this.controls.bColors) {
            TraitColorsDialog traitColorsDialog = new TraitColorsDialog(this.dataSet);
        }
    }

    public void removeAllTraits() {
        this.dataSet.getTraits().clear();
        for (Line line : this.dataSet.getLines()) {
            line.getTraitValues().clear();
        }
        for (GTViewSet viewSet : this.dataSet.getViewSets()) {
            viewSet.setTraits(new int[0]);
            viewSet.setTxtTraits(new int[0]);
        }
        this.updateModel();
        Actions.projectModified();
    }
}

