/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.Prefs;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;
import scri.commons.gui.matisse.DialogPanel;
import scri.commons.gui.matisse.HistoryComboBox;

public class ExportDialog
extends JDialog
implements ActionListener {
    private boolean isOK = false;
    private JRadioButton bAllLines;
    private JButton bBrowse;
    private JButton bCancel;
    private JButton bExport;
    private ButtonGroup bGroup;
    private JButton bHelp;
    private JRadioButton bVisLines;
    private JRadioButton bVisSelLines;
    private JCheckBox checkHeaders;
    private DialogPanel dialogPanel1;
    private JLabel fileLabel;
    private HistoryComboBox filename;
    private JLabel selectLabel;

    public ExportDialog() {
        super(Flapjack.winMain, RB.getString((String)"gui.table.ExportDialog.title"), true);
        this.initComponents();
        RB.setText((AbstractButton)this.bCancel, (String)"gui.text.cancel");
        RB.setText((AbstractButton)this.bExport, (String)"gui.table.ExportDialog.bExport");
        RB.setText((AbstractButton)this.bHelp, (String)"gui.text.help");
        FlapjackUtils.setHelp(this.bHelp, "analysis_results_tables.html#exporting-to-a-file");
        this.initOptions();
        this.bBrowse.addActionListener(this);
        this.bExport.addActionListener(this);
        this.bCancel.addActionListener(this);
        FlapjackUtils.initDialog(this, this.bExport, this.bCancel, true, this.getContentPane());
    }

    private void initOptions() {
        this.filename.setHistory(Prefs.guiLDTableExportHistory);
        this.bGroup.add(this.bAllLines);
        this.bGroup.add(this.bVisLines);
        this.bGroup.add(this.bVisSelLines);
        switch (Prefs.guiLDTableExportType) {
            case 0: {
                this.bAllLines.setSelected(true);
                break;
            }
            case 1: {
                this.bVisLines.setSelected(true);
                break;
            }
            case 2: {
                this.bVisSelLines.setSelected(true);
            }
        }
        this.checkHeaders.setSelected(Prefs.guiLDTableExportHeaders);
    }

    private boolean saveOptions() {
        if (this.filename.getText().isEmpty()) {
            TaskDialog.warning((String)"You must supply a file name to write the exported data to.", (String)RB.getString((String)"gui.text.ok"));
            return false;
        }
        Prefs.guiLDTableExportHistory = this.filename.getHistory();
        if (this.bAllLines.isSelected()) {
            Prefs.guiLDTableExportType = 0;
        } else if (this.bVisLines.isSelected()) {
            Prefs.guiLDTableExportType = 1;
        } else if (this.bVisSelLines.isSelected()) {
            Prefs.guiLDTableExportType = 2;
        }
        Prefs.guiLDTableExportHeaders = this.checkHeaders.isSelected();
        return true;
    }

    File getFilename() {
        return new File(this.filename.getText());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bBrowse) {
            this.browseForFile();
        } else if (e.getSource() == this.bExport) {
            if (!this.saveOptions()) {
                return;
            }
            this.isOK = true;
            this.setVisible(false);
        } else if (e.getSource() == this.bCancel) {
            this.setVisible(false);
        }
    }

    public boolean isOK() {
        return this.isOK;
    }

    private void browseForFile() {
        FileNameExtensionFilter filter;
        String file;
        File saveAs = new File(Prefs.guiCurrentDir, "table-data.txt");
        if (!this.filename.getText().isEmpty()) {
            saveAs = new File(this.filename.getText());
        }
        if ((file = FlapjackUtils.getSaveFilename("Save table data as", saveAs, filter = new FileNameExtensionFilter(RB.getString((String)"other.Filters.txt"), "txt"))) != null) {
            this.filename.updateComboBox(file);
        }
    }

    private void initComponents() {
        this.bGroup = new ButtonGroup();
        this.dialogPanel1 = new DialogPanel();
        this.bExport = new JButton();
        this.bCancel = new JButton();
        this.bHelp = new JButton();
        this.fileLabel = new JLabel();
        this.filename = new HistoryComboBox();
        this.bBrowse = new JButton();
        this.selectLabel = new JLabel();
        this.bAllLines = new JRadioButton();
        this.bVisLines = new JRadioButton();
        this.bVisSelLines = new JRadioButton();
        this.checkHeaders = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.bExport.setText("Export");
        this.dialogPanel1.add((Component)this.bExport);
        this.bCancel.setText("Cancel");
        this.dialogPanel1.add((Component)this.bCancel);
        this.bHelp.setText("Help");
        this.dialogPanel1.add((Component)this.bHelp);
        this.fileLabel.setText("File name:");
        this.bBrowse.setText("Browse...");
        this.selectLabel.setText("Select which lines to include in the output:");
        this.bAllLines.setText("All lines");
        this.bVisLines.setText("Only visible (non-filtered) lines");
        this.bVisSelLines.setText("Only visible (non-filtered) lines that are selected");
        this.checkHeaders.setText("Include header rows with details of any active filter or sort parameters");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dialogPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.fileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.filename, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bBrowse)).addGroup(layout.createSequentialGroup().addComponent(this.selectLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bVisLines).addComponent(this.bAllLines).addComponent(this.bVisSelLines)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.checkHeaders).addGap(0, 125, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLabel).addComponent((Component)this.filename, -2, -1, -2).addComponent(this.bBrowse)).addGap(18, 18, 18).addComponent(this.selectLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bAllLines).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bVisLines).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bVisSelLines).addGap(18, 18, 18).addComponent(this.checkHeaders).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.dialogPanel1, -2, 46, -2)));
        this.pack();
    }
}

