/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.importer;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jhi.flapjack.io.FlapjackFile;
import scri.commons.gui.Icons;
import scri.commons.gui.RB;

class ImportSampleTabNB
extends JPanel
implements ActionListener,
Runnable {
    private Properties properties;
    private boolean isOK = false;
    private JButton bImport;
    JComboBox<ExampleProject> combo;
    private JScrollPane jScrollPane1;
    private JPanel panel;
    private JLabel serverLabel;
    private JLabel tabLabel;
    JTextArea text;

    public ImportSampleTabNB(JButton bImport) {
        this.initComponents();
        this.bImport = bImport;
        this.setBackground((Color)UIManager.get("fjDialogBG"));
        this.panel.setBackground((Color)UIManager.get("fjDialogBG"));
        this.panel.setBorder(BorderFactory.createTitledBorder(RB.getString((String)"gui.dialog.NBImportSamplePanel.panel")));
        RB.setText((JLabel)this.tabLabel, (String)"gui.dialog.NBImportSamplePanel.tabLabel");
        RB.setText((JLabel)this.serverLabel, (String)"gui.dialog.NBImportSamplePanel.serverLabel.connecting");
        this.serverLabel.setIcon(Icons.getIcon((String)"TIMERON"));
        this.combo.addActionListener(this);
        new Thread(this).start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateDetailsBox(this.combo.getSelectedIndex());
    }

    private void updateDetailsBox(int index) {
        ExampleProject proj = this.combo.getItemAt(index);
        if (proj != null) {
            this.text.setText(proj.des);
        }
    }

    FlapjackFile getProject() {
        String url = ((ExampleProject)this.combo.getSelectedItem()).url;
        return new FlapjackFile(url);
    }

    @Override
    public void run() {
        try {
            URL url = new URL("http://bioinf.hutton.ac.uk/flapjack/sample-data/sample.xml");
            this.properties = new Properties();
            this.properties.loadFromXML(url.openStream());
            ArrayList<ExampleProject> list = new ArrayList<ExampleProject>();
            Enumeration<Object> e = this.properties.keys();
            while (e.hasMoreElements()) {
                ExampleProject proj = new ExampleProject();
                proj.name = (String)e.nextElement();
                String value = this.properties.getProperty(proj.name);
                proj.url = value.substring(0, value.indexOf(";"));
                proj.des = value.substring(value.indexOf(";") + 1);
                proj.idx = Integer.parseInt(proj.name.substring(0, 1));
                list.add(proj);
                Collections.sort(list);
            }
            for (ExampleProject proj : list) {
                this.combo.addItem(proj);
            }
            this.serverLabel.setText(RB.format((String)"gui.dialog.NBImportSamplePanel.serverLabel.ok", (Object[])new Object[]{list.size()}));
            this.isOK = true;
            this.bImport.setEnabled(true);
            this.combo.setEnabled(true);
        }
        catch (Exception e) {
            RB.setText((JLabel)this.serverLabel, (String)"gui.dialog.NBImportSamplePanel.serverLabel.error");
            this.serverLabel.setForeground(Color.red);
        }
        this.serverLabel.setIcon(Icons.getIcon((String)"CHECKUPDATE"));
    }

    boolean isOK() {
        return this.isOK;
    }

    private void initComponents() {
        this.panel = new JPanel();
        this.combo = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.text = new JTextArea();
        this.serverLabel = new JLabel();
        this.tabLabel = new JLabel();
        this.panel.setBorder(BorderFactory.createTitledBorder("Available example data:"));
        this.combo.setEnabled(false);
        this.text.setColumns(20);
        this.text.setEditable(false);
        this.text.setLineWrap(true);
        this.text.setRows(2);
        this.text.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.text);
        this.serverLabel.setText("Server message...");
        GroupLayout panelLayout = new GroupLayout(this.panel);
        this.panel.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayout.createSequentialGroup().addContainerGap().addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 251, Short.MAX_VALUE).addComponent(this.combo, GroupLayout.Alignment.TRAILING, 0, 251, Short.MAX_VALUE).addComponent(this.serverLabel)).addContainerGap()));
        panelLayout.setVerticalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayout.createSequentialGroup().addContainerGap().addComponent(this.combo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 68, -2).addGap(18, 18, 18).addComponent(this.serverLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.tabLabel.setText("Status message...");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panel, -1, -1, Short.MAX_VALUE).addComponent(this.tabLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabLabel).addGap(18, 18, 18).addComponent(this.panel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private static class ExampleProject
    implements Comparable<ExampleProject> {
        String url;
        String name;
        String des;
        int idx;

        private ExampleProject() {
        }

        public String toString() {
            return this.name.substring(this.name.indexOf(":") + 1);
        }

        @Override
        public int compareTo(ExampleProject other) {
            if (this.idx < other.idx) {
                return -1;
            }
            if (this.idx == other.idx) {
                return 0;
            }
            return 1;
        }
    }
}

