/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.analysis;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import jhi.flapjack.analysis.AnalysisSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.dialog.analysis.ChromosomeSelectionDialog;
import scri.commons.gui.RB;
import scri.commons.gui.matisse.DialogPanel;
import scri.commons.gui.matisse.HyperLinkLabel;

public class PedVerF1StatsDialog
extends JDialog
implements ActionListener {
    private ChromosomeSelectionDialog csd;
    private boolean isOK = false;
    private ButtonGroup f1Group;
    private DefaultComboBoxModel<LineInfo> parent1Model;
    private DefaultComboBoxModel<LineInfo> parent2Model;
    private DefaultComboBoxModel<LineInfo> f1Model;
    private JButton bCancel;
    private JButton bHelp;
    private JButton bOK;
    private JCheckBox chkExcludeParents;
    private HyperLinkLabel csdLabel;
    private DialogPanel dialogPanel1;
    private JComboBox<LineInfo> f1Combo;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JLabel lblParent1;
    private JLabel lblParent2;
    private JComboBox<LineInfo> parent1Combo;
    private JComboBox<LineInfo> parent2Combo;
    private JPanel parentsPanel;
    private JRadioButton rdbSelectF1;
    private JRadioButton rdbSimulateF1;

    public PedVerF1StatsDialog(GTViewSet viewSet) {
        super(Flapjack.winMain, RB.getString((String)"gui.dialog.analysis.PedVerF1StatsDialog.title"), true);
        this.initComponents();
        this.initComponents2();
        AnalysisSet as = new AnalysisSet(viewSet).withViews(null).withSelectedLines().withSelectedMarkers();
        this.csd = new ChromosomeSelectionDialog(viewSet, true);
        this.csdLabel.addActionListener(e -> this.csd.setVisible(true));
        this.setupF1ButtonGroup();
        this.setupComboBoxes(as);
        this.rdbSimulateF1.setSelected(true);
        FlapjackUtils.initDialog(this, this.bOK, this.bCancel, true, this.getContentPane(), this.jPanel1, this.parentsPanel);
    }

    private void setupComboBoxes(AnalysisSet as) {
        this.parent1Model = this.createComboModelFrom(as);
        this.parent1Combo.setModel(this.parent1Model);
        if (as.lineCount() >= 1) {
            this.parent1Combo.setSelectedIndex(0);
        }
        this.parent2Model = this.createComboModelFrom(as);
        this.parent2Combo.setModel(this.parent2Model);
        if (as.lineCount() >= 2) {
            this.parent2Combo.setSelectedIndex(1);
        }
        this.f1Model = this.createComboModelFrom(as);
        this.f1Combo.setModel(this.f1Model);
        if (as.lineCount() >= 3) {
            this.f1Combo.setSelectedIndex(2);
        }
        this.f1Combo.setEnabled(this.rdbSelectF1.isSelected());
    }

    private DefaultComboBoxModel<LineInfo> createComboModelFrom(AnalysisSet as) {
        DefaultComboBoxModel<LineInfo> model = new DefaultComboBoxModel<LineInfo>();
        for (int i = 0; i < as.lineCount(); ++i) {
            model.addElement(as.getLine(i));
        }
        return model;
    }

    private void initComponents2() {
        this.bOK.addActionListener(this);
        RB.setText((AbstractButton)this.bCancel, (String)"gui.text.cancel");
        this.bCancel.addActionListener(this);
        RB.setText((AbstractButton)this.bHelp, (String)"gui.text.help");
        FlapjackUtils.setHelp(this.bHelp, "pedver_f1s_known_parents.html");
        RB.setText((AbstractButton)this.chkExcludeParents, (String)"gui.dialog.analysis.MABCStatsDialog.chkExlcudeParents");
        this.chkExcludeParents.addActionListener(this);
        this.chkExcludeParents.setSelected(Prefs.guiPedVerF1sExcludeParents);
        this.rdbSelectF1.addActionListener(e -> this.f1Combo.setEnabled(this.rdbSelectF1.isSelected()));
        this.rdbSimulateF1.addActionListener(e -> this.f1Combo.setEnabled(this.rdbSelectF1.isSelected()));
    }

    private void setupF1ButtonGroup() {
        this.f1Group = new ButtonGroup();
        this.f1Group.add(this.rdbSelectF1);
        this.f1Group.add(this.rdbSimulateF1);
    }

    public boolean isOK() {
        return this.isOK;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bOK) {
            this.isOK = true;
            this.setVisible(false);
        } else if (e.getSource() == this.bCancel) {
            this.setVisible(false);
        } else if (e.getSource() == this.chkExcludeParents) {
            Prefs.guiPedVerF1sExcludeParents = this.chkExcludeParents.isSelected();
        }
    }

    public int getParent1() {
        return this.parent1Combo.getSelectedIndex();
    }

    public int getParent2() {
        return this.parent2Combo.getSelectedIndex();
    }

    public int getF1() {
        return this.f1Combo.getSelectedIndex();
    }

    public boolean simulateF1() {
        return this.rdbSimulateF1.isSelected();
    }

    public boolean[] getSelectedChromosomes() {
        return this.csd.getSelectedChromosomes();
    }

    private void initComponents() {
        this.parentsPanel = new JPanel();
        this.lblParent1 = new JLabel();
        this.parent1Combo = new JComboBox();
        this.lblParent2 = new JLabel();
        this.parent2Combo = new JComboBox();
        this.rdbSimulateF1 = new JRadioButton();
        this.rdbSelectF1 = new JRadioButton();
        this.f1Combo = new JComboBox();
        this.jLabel1 = new JLabel();
        this.chkExcludeParents = new JCheckBox();
        this.dialogPanel1 = new DialogPanel();
        this.bOK = new JButton();
        this.bCancel = new JButton();
        this.bHelp = new JButton();
        this.jPanel1 = new JPanel();
        this.csdLabel = new HyperLinkLabel();
        this.setDefaultCloseOperation(2);
        this.parentsPanel.setBorder(BorderFactory.createTitledBorder("Select parents:"));
        this.lblParent1.setText("Select parent line 1:");
        this.lblParent1.setToolTipText("");
        this.lblParent2.setText("Select parent line 2:");
        this.lblParent2.setToolTipText("");
        this.rdbSimulateF1.setText("Simulate an F1 from the parents (above)");
        this.rdbSelectF1.setActionCommand("");
        this.rdbSelectF1.setText("Select an F1 from the existing lines:");
        this.jLabel1.setText("<html>Pedigree Verification of F1s (Known Parents) will calculate statistics for each line comparing<br>it to the parents and either a supplied or simulated F1.");
        this.chkExcludeParents.setText("Exclude other parental lines from analysis and view");
        GroupLayout parentsPanelLayout = new GroupLayout(this.parentsPanel);
        this.parentsPanel.setLayout(parentsPanelLayout);
        parentsPanelLayout.setHorizontalGroup(parentsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(parentsPanelLayout.createSequentialGroup().addContainerGap().addGroup(parentsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(parentsPanelLayout.createSequentialGroup().addComponent(this.lblParent1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.parent1Combo, 0, -1, Short.MAX_VALUE)).addGroup(parentsPanelLayout.createSequentialGroup().addComponent(this.lblParent2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.parent2Combo, 0, -1, Short.MAX_VALUE)).addGroup(parentsPanelLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.f1Combo, 0, -1, Short.MAX_VALUE)).addGroup(parentsPanelLayout.createSequentialGroup().addGroup(parentsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkExcludeParents).addComponent(this.rdbSelectF1).addComponent(this.rdbSimulateF1)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        parentsPanelLayout.setVerticalGroup(parentsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, parentsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addGap(18, 18, 18).addGroup(parentsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblParent1).addComponent(this.parent1Combo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(parentsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblParent2).addComponent(this.parent2Combo, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.chkExcludeParents).addGap(18, 18, 18).addComponent(this.rdbSimulateF1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rdbSelectF1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.f1Combo, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.bOK.setText("Run");
        this.dialogPanel1.add((Component)this.bOK);
        this.bCancel.setText("Cancel");
        this.dialogPanel1.add((Component)this.bCancel);
        this.bHelp.setText("Help");
        this.dialogPanel1.add((Component)this.bHelp);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Data selection settings:"));
        this.csdLabel.setText("Select chromosomes to analyse");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent((Component)this.csdLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent((Component)this.csdLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dialogPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.parentsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.parentsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dialogPanel1, -2, -1, -2)));
        this.pack();
    }
}

