/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.Trait;
import jhi.flapjack.data.TraitValue;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.Prefs;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;
import scri.commons.gui.matisse.DialogPanel;

public class TraitColorsDialog
extends JDialog {
    private DataSet dataSet;
    private Trait selectedTrait;
    private static Hashtable<String, Color> selectedColors = new Hashtable();
    private DefaultComboBoxModel<Trait> comboModel = new DefaultComboBoxModel();
    private DefaultListModel<String> highlowAllModel = new DefaultListModel();
    private DefaultListModel<String> highlowModel = new DefaultListModel();
    private DefaultListModel<String> categoriesModel = new DefaultListModel();
    private JPanel allPanel;
    private JButton bClose;
    private JButton bHelp;
    private JButton bReset;
    private DialogPanel dialogPanel1;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JList<String> listCategories;
    private JList<String> listHighLow;
    private JList<String> listHighLowAll;
    private JPanel traitPanel;
    private JComboBox<Trait> traitsCombo;

    public TraitColorsDialog(DataSet dataSet) {
        super(Flapjack.winMain, "Trait Colours", true);
        this.dataSet = dataSet;
        this.initComponents();
        this.initComponents2();
        FlapjackUtils.initDialog(this, this.bClose, this.bClose, true, this.getContentPane());
    }

    private void initComponents2() {
        this.getContentPane().setBackground(Color.WHITE);
        this.allPanel.setBackground(Color.WHITE);
        this.traitPanel.setBackground(Color.WHITE);
        this.bClose.addActionListener(e -> this.setVisible(false));
        this.bReset.addActionListener(e -> this.resetColors());
        this.traitsCombo.setModel(this.comboModel);
        this.traitsCombo.addItemListener(e -> this.selectTrait());
        for (Trait trait : this.dataSet.getTraits()) {
            this.comboModel.addElement(trait);
        }
        this.initList(this.listHighLowAll, this.highlowAllModel);
        this.initList(this.listHighLow, this.highlowModel);
        this.initList(this.listCategories, this.categoriesModel);
        this.selectTrait();
    }

    private void initList(final JList<String> list, DefaultListModel<String> model) {
        list.setModel(model);
        list.setCellRenderer(new ColorListRenderer());
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TraitColorsDialog.this.pickNewColor(list);
                }
            }
        });
        if (list != this.listCategories) {
            model.addElement("Low");
            model.addElement("High");
        }
    }

    public void resetColors() {
        String msg = "This will reset all colours back to their default values. Are you sure?";
        String[] options = new String[]{"Reset", RB.getString((String)"gui.text.cancel")};
        if (TaskDialog.show((String)msg, (int)3, (int)1, (String[])options) == 0) {
            Prefs.visColorHeatmapLow = new Color(120, 255, 120);
            Prefs.visColorHeatmapHigh = new Color(255, 120, 120);
            for (Trait trait : this.dataSet.getTraits()) {
                trait.getColors().clear();
            }
            this.refreshScreen();
        }
    }

    private void refreshScreen() {
        Flapjack.winMain.repaint();
        Actions.projectModified();
        this.listHighLowAll.repaint();
        this.listHighLow.repaint();
        this.selectTrait();
    }

    private void selectTrait() {
        this.categoriesModel.clear();
        int index = this.traitsCombo.getSelectedIndex();
        this.selectedTrait = this.comboModel.getElementAt(index);
        if (!this.selectedTrait.traitIsNumerical()) {
            this.listCategories.setEnabled(true);
            for (Line line : this.dataSet.getLines()) {
                TraitValue tv = line.getTraitValues().get(index);
                selectedColors.put(this.selectedTrait.format(tv), tv.displayColor());
            }
            for (String category : this.selectedTrait.getCategories()) {
                this.categoriesModel.addElement(category);
            }
        } else {
            this.listCategories.setEnabled(false);
        }
    }

    private void pickNewColor(JList<String> list) {
        String key = list.getSelectedValue();
        if (key == null) {
            return;
        }
        Color c = this.getColor(list, key);
        Color newColor = JColorChooser.showDialog(this, "Select New Colour", c);
        if (newColor == null) {
            return;
        }
        if (list == this.listHighLowAll) {
            if (key.equals("Low")) {
                Prefs.visColorHeatmapLow = newColor;
            } else {
                Prefs.visColorHeatmapHigh = newColor;
            }
        } else if (list == this.listHighLow) {
            if (key.equals("Low")) {
                this.selectedTrait.getColors().put("FLAPJACK_LW", newColor);
            } else {
                this.selectedTrait.getColors().put("FLAPJACK_HG", newColor);
            }
        } else {
            this.selectedTrait.getColors().put(key, newColor);
            selectedColors.put(key, newColor);
        }
        this.refreshScreen();
    }

    private Color getColor(JList list, String key) {
        if (list == this.listHighLowAll) {
            if (key.equals("Low")) {
                return Prefs.visColorHeatmapLow;
            }
            return Prefs.visColorHeatmapHigh;
        }
        if (list == this.listHighLow) {
            if (key.equals("Low")) {
                return this.selectedTrait.getColors().queryLow();
            }
            return this.selectedTrait.getColors().queryHigh();
        }
        return selectedColors.get(key);
    }

    private void initComponents() {
        this.dialogPanel1 = new DialogPanel();
        this.bClose = new JButton();
        this.bReset = new JButton();
        this.bHelp = new JButton();
        this.allPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.listHighLowAll = new JList();
        this.traitPanel = new JPanel();
        this.traitsCombo = new JComboBox();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.listHighLow = new JList();
        this.jScrollPane3 = new JScrollPane();
        this.listCategories = new JList();
        this.setDefaultCloseOperation(2);
        this.bClose.setText("Close");
        this.dialogPanel1.add((Component)this.bClose);
        this.bReset.setText("Reset");
        this.dialogPanel1.add((Component)this.bReset);
        this.bHelp.setText("Help");
        this.dialogPanel1.add((Component)this.bHelp);
        this.allPanel.setBorder(BorderFactory.createTitledBorder("Applies to all traits:"));
        this.jScrollPane1.setViewportView(this.listHighLowAll);
        GroupLayout allPanelLayout = new GroupLayout(this.allPanel);
        this.allPanel.setLayout(allPanelLayout);
        allPanelLayout.setHorizontalGroup(allPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(allPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 141, Short.MAX_VALUE).addContainerGap()));
        allPanelLayout.setVerticalGroup(allPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(allPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 140, Short.MAX_VALUE).addContainerGap()));
        this.traitPanel.setBorder(BorderFactory.createTitledBorder("Selected trait only:"));
        this.jPanel3.setLayout(new GridLayout(1, 2, 5, 5));
        this.jScrollPane2.setViewportView(this.listHighLow);
        this.jPanel3.add(this.jScrollPane2);
        this.jScrollPane3.setViewportView(this.listCategories);
        this.jPanel3.add(this.jScrollPane3);
        GroupLayout traitPanelLayout = new GroupLayout(this.traitPanel);
        this.traitPanel.setLayout(traitPanelLayout);
        traitPanelLayout.setHorizontalGroup(traitPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, traitPanelLayout.createSequentialGroup().addContainerGap().addGroup(traitPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel3, -2, 0, Short.MAX_VALUE).addComponent(this.traitsCombo, 0, 286, Short.MAX_VALUE)).addContainerGap()));
        traitPanelLayout.setVerticalGroup(traitPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(traitPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.traitsCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, 0, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dialogPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.allPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.traitPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.allPanel, -1, -1, Short.MAX_VALUE).addComponent(this.traitPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dialogPanel1, -2, -1, -2)));
        this.pack();
    }

    class ColorListRenderer
    extends DefaultListCellRenderer {
        ColorListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object o, int i, boolean iss, boolean chf) {
            super.getListCellRendererComponent((JList<?>)list, o, i, iss, chf);
            String category = (String)o;
            this.setText(category);
            BufferedImage image = new BufferedImage(20, 10, 1);
            Graphics2D g = image.createGraphics();
            Color c1 = TraitColorsDialog.this.getColor(list, category).brighter();
            Color c2 = TraitColorsDialog.this.getColor(list, category).darker();
            g.setPaint(new GradientPaint(0.0f, 0.0f, c1, 20.0f, 10.0f, c2));
            g.fillRect(0, 0, 20, 10);
            g.setColor(Color.black);
            g.drawRect(0, 0, 20, 10);
            g.dispose();
            this.setIcon(new ImageIcon(image));
            return this;
        }

        @Override
        public Insets getInsets(Insets i) {
            return new Insets(0, 3, 0, 0);
        }
    }
}

