/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import java.util.ArrayList;
import java.util.Collections;
import jhi.flapjack.analysis.SortLines;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.TraitValue;

public class SortLinesByTrait
extends SortLines {
    private int[] traits;
    private boolean[] asc;
    private boolean autoAssign;

    public SortLinesByTrait(GTViewSet viewSet, int[] traits, boolean[] asc, boolean autoAssign) {
        super(viewSet);
        this.traits = traits;
        this.asc = asc;
        this.autoAssign = autoAssign;
    }

    public SortLinesByTrait(GTViewSet viewSet, int trait, boolean asc) {
        super(viewSet);
        this.traits = new int[]{trait};
        this.asc = new boolean[]{asc};
        this.autoAssign = false;
    }

    @Override
    protected ArrayList<LineInfo> doSort(GTView view) {
        int numLines = view.lineCount();
        ArrayList<LineScore> scores = new ArrayList<LineScore>(numLines);
        int i = 0;
        while (i < numLines && this.okToRun) {
            if (!view.isSplitter(i)) {
                scores.add(new LineScore(view.getViewSet().getLines().get(i)));
            }
            ++i;
            ++this.linesScored;
        }
        Collections.sort(scores);
        ArrayList<LineInfo> lineOrder = new ArrayList<LineInfo>(numLines);
        for (int i2 = 0; i2 < scores.size() && this.okToRun; ++i2) {
            lineOrder.add(((LineScore)scores.get(i2)).lineInfo);
        }
        return lineOrder;
    }

    @Override
    public void runJob(int jobIndex) {
        super.runJob(jobIndex);
        if (this.autoAssign) {
            this.viewSet.setTraits(this.traits);
        }
    }

    private class LineScore
    implements Comparable<LineScore> {
        private LineInfo lineInfo;
        private TraitValue[] tv;

        LineScore(LineInfo lineInfo) {
            this.lineInfo = lineInfo;
            Line line = lineInfo.getLine();
            ArrayList<TraitValue> traitValues = line.getTraitValues();
            this.tv = new TraitValue[SortLinesByTrait.this.traits.length];
            for (int i = 0; i < SortLinesByTrait.this.traits.length; ++i) {
                this.tv[i] = traitValues.get(SortLinesByTrait.this.traits[i]);
            }
        }

        @Override
        public int compareTo(LineScore other) {
            return this.compareTo(other, 0);
        }

        public int compareTo(LineScore other, int i) {
            int result = this.tv[i].compareTo(other.tv[i]);
            if (!SortLinesByTrait.this.asc[i]) {
                result *= -1;
            }
            if (result == 0 && i < SortLinesByTrait.this.traits.length - 1) {
                return this.compareTo(other, i + 1);
            }
            return result;
        }
    }
}

