/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5MemberByteifyer;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFNativeData;

class PaddingUtils {
    private static final int machineWordSize = HDFNativeData.getMachineWordSize();

    private PaddingUtils() {
    }

    static int padOffset(int offset, int elementSize) {
        if (elementSize > 0) {
            int actualElementSize = Math.min(elementSize, machineWordSize);
            int mod = offset % actualElementSize;
            return mod > 0 ? offset + actualElementSize - mod : offset;
        }
        return offset;
    }

    static int findMaxElementSize(HDF5MemberByteifyer[] byteifyers) {
        int maxElementSize = 0;
        HDF5MemberByteifyer[] hDF5MemberByteifyerArray = byteifyers;
        int n = byteifyers.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5MemberByteifyer b = hDF5MemberByteifyerArray[n2];
            if ((maxElementSize = Math.max(maxElementSize, b.getElementSize())) >= machineWordSize) {
                return machineWordSize;
            }
            ++n2;
        }
        return maxElementSize;
    }
}

