/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDByteArray;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5MDDataBlock;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlock1DParameters;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlockMDParameters;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5ByteReader;
import ch.systemsx.cisd.hdf5.IndexMap;
import ch.systemsx.cisd.hdf5.MatrixUtils;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import ncsa.hdf.hdf5lib.exceptions.HDF5SpaceRankMismatch;

class HDF5ByteReader
implements IHDF5ByteReader {
    private final HDF5BaseReader baseReader;

    HDF5ByteReader(HDF5BaseReader baseReader) {
        assert (baseReader != null);
        this.baseReader = baseReader;
    }

    HDF5BaseReader getBaseReader() {
        return this.baseReader;
    }

    @Override
    public byte getAttr(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Byte> getAttributeRunnable = new ICallableWithCleanUp<Byte>(){

            @Override
            public Byte call(ICleanUpRegistry registry) {
                int objectId = ((HDF5ByteReader)HDF5ByteReader.this).baseReader.h5.openObject(((HDF5ByteReader)HDF5ByteReader.this).baseReader.fileId, objectPath, registry);
                int attributeId = ((HDF5ByteReader)HDF5ByteReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                byte[] data = ((HDF5ByteReader)HDF5ByteReader.this).baseReader.h5.readAttributeAsByteArray(attributeId, HDF5Constants.H5T_NATIVE_INT8, 1);
                return data[0];
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public byte[] getArrayAttr(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<byte[]> getAttributeRunnable = new ICallableWithCleanUp<byte[]>(){

            @Override
            public byte[] call(ICleanUpRegistry registry) {
                int objectId = ((HDF5ByteReader)HDF5ByteReader.this).baseReader.h5.openObject(((HDF5ByteReader)HDF5ByteReader.this).baseReader.fileId, objectPath, registry);
                return HDF5ByteReader.this.getByteArrayAttribute(objectId, attributeName, registry);
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public MDByteArray getMDArrayAttr(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDByteArray> getAttributeRunnable = new ICallableWithCleanUp<MDByteArray>(){

            @Override
            public MDByteArray call(ICleanUpRegistry registry) {
                int objectId = ((HDF5ByteReader)HDF5ByteReader.this).baseReader.h5.openObject(((HDF5ByteReader)HDF5ByteReader.this).baseReader.fileId, objectPath, registry);
                return HDF5ByteReader.this.getByteMDArrayAttribute(objectId, attributeName, registry);
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public byte[][] getMatrixAttr(String objectPath, String attributeName) throws HDF5JavaException {
        MDByteArray array = this.getMDArrayAttr(objectPath, attributeName);
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public byte read(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Byte> readCallable = new ICallableWithCleanUp<Byte>(){

            @Override
            public Byte call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5ByteReader)HDF5ByteReader.this).baseReader.h5.openDataSet(((HDF5ByteReader)HDF5ByteReader.this).baseReader.fileId, objectPath, registry);
                byte[] data = new byte[1];
                ((HDF5ByteReader)HDF5ByteReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT8, data);
                return data[0];
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public byte[] readArray(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<byte[]> readCallable = new ICallableWithCleanUp<byte[]>(){

            @Override
            public byte[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5ByteReader)HDF5ByteReader.this).baseReader.h5.openDataSet(((HDF5ByteReader)HDF5ByteReader.this).baseReader.fileId, objectPath, registry);
                return HDF5ByteReader.this.readByteArray(dataSetId, registry);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    private byte[] readByteArray(int dataSetId, ICleanUpRegistry registry) {
        try {
            HDF5BaseReader.DataSpaceParameters spaceParams = this.baseReader.getSpaceParameters(dataSetId, registry);
            byte[] data = new byte[spaceParams.blockSize];
            this.baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT8, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
            return data;
        }
        catch (HDF5LibraryException ex) {
            int dataTypeId;
            if (ex.getMajorErrorNumber() == HDF5Constants.H5E_DATATYPE && ex.getMinorErrorNumber() == HDF5Constants.H5E_CANTINIT && this.baseReader.h5.getClassType(dataTypeId = this.baseReader.h5.getDataTypeForDataSet(dataSetId, registry)) == HDF5Constants.H5T_ARRAY) {
                return this.readByteArrayFromArrayType(dataSetId, dataTypeId, registry);
            }
            throw ex;
        }
    }

    private byte[] readByteArrayFromArrayType(int dataSetId, int dataTypeId, ICleanUpRegistry registry) {
        int spaceId = this.baseReader.h5.createScalarDataSpace();
        int[] dimensions = this.baseReader.h5.getArrayDimensions(dataTypeId);
        byte[] data = new byte[HDF5Utils.getOneDimensionalArraySize(dimensions)];
        int memoryDataTypeId = this.baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT8, data.length, registry);
        this.baseReader.h5.readDataSet(dataSetId, memoryDataTypeId, spaceId, spaceId, data);
        return data;
    }

    @Override
    public int[] readToMDArrayWithOffset(final String objectPath, final MDByteArray array, final int[] memoryOffset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> readCallable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5ByteReader)HDF5ByteReader.this).baseReader.h5.openDataSet(((HDF5ByteReader)HDF5ByteReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5ByteReader.this.baseReader.getBlockSpaceParameters(dataSetId, memoryOffset, array.dimensions(), registry);
                int nativeDataTypeId = HDF5ByteReader.this.baseReader.getNativeDataTypeId(dataSetId, HDF5Constants.H5T_NATIVE_INT8, registry);
                ((HDF5ByteReader)HDF5ByteReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, array.getAsFlatArray());
                return MDArray.toInt(spaceParams.dimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public int[] readToMDArrayBlockWithOffset(final String objectPath, final MDByteArray array, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> readCallable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5ByteReader)HDF5ByteReader.this).baseReader.h5.openDataSet(((HDF5ByteReader)HDF5ByteReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5ByteReader.this.baseReader.getBlockSpaceParameters(dataSetId, memoryOffset, array.dimensions(), offset, blockDimensions, registry);
                int nativeDataTypeId = HDF5ByteReader.this.baseReader.getNativeDataTypeId(dataSetId, HDF5Constants.H5T_NATIVE_INT8, registry);
                ((HDF5ByteReader)HDF5ByteReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, array.getAsFlatArray());
                return MDArray.toInt(spaceParams.dimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public byte[] readArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.readArrayBlockWithOffset(objectPath, blockSize, blockNumber * (long)blockSize);
    }

    @Override
    public byte[] readArrayBlockWithOffset(final String objectPath, final int blockSize, final long offset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<byte[]> readCallable = new ICallableWithCleanUp<byte[]>(){

            @Override
            public byte[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5ByteReader)HDF5ByteReader.this).baseReader.h5.openDataSet(((HDF5ByteReader)HDF5ByteReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5ByteReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockSize, registry);
                byte[] data = new byte[spaceParams.blockSize];
                ((HDF5ByteReader)HDF5ByteReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT8, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public byte[][] readMatrix(String objectPath) throws HDF5JavaException {
        MDByteArray array = this.readMDArray(objectPath);
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public byte[][] readMatrixBlock(String objectPath, int blockSizeX, int blockSizeY, long blockNumberX, long blockNumberY) throws HDF5JavaException {
        MDByteArray array = this.readMDArrayBlock(objectPath, new int[]{blockSizeX, blockSizeY}, new long[]{blockNumberX, blockNumberY});
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public byte[][] readMatrixBlockWithOffset(String objectPath, int blockSizeX, int blockSizeY, long offsetX, long offsetY) throws HDF5JavaException {
        MDByteArray array = this.readMDArrayBlockWithOffset(objectPath, new int[]{blockSizeX, blockSizeY}, new long[]{offsetX, offsetY});
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public MDByteArray readMDArraySlice(String objectPath, IndexMap boundIndices) {
        this.baseReader.checkOpen();
        long[] fullDimensions = this.baseReader.getDimensions(objectPath);
        int[] fullBlockDimensions = new int[fullDimensions.length];
        long[] fullOffset = new long[fullDimensions.length];
        int cardBoundIndices = MatrixUtils.cardinalityBoundIndices(boundIndices);
        MatrixUtils.checkBoundIndices(objectPath, fullDimensions, cardBoundIndices);
        int[] effectiveBlockDimensions = new int[fullBlockDimensions.length - cardBoundIndices];
        Arrays.fill(effectiveBlockDimensions, -1);
        MatrixUtils.createFullBlockDimensionsAndOffset(effectiveBlockDimensions, null, (Map<Integer, Long>)boundIndices, fullDimensions, fullBlockDimensions, fullOffset);
        MDByteArray result = this.readMDArrayBlockWithOffset(objectPath, fullBlockDimensions, fullOffset);
        if (fullBlockDimensions.length == cardBoundIndices) {
            return new MDByteArray(result.getAsFlatArray(), new int[]{1});
        }
        return new MDByteArray(result.getAsFlatArray(), effectiveBlockDimensions);
    }

    @Override
    public MDByteArray readMDArraySlice(String objectPath, long[] boundIndices) {
        this.baseReader.checkOpen();
        long[] fullDimensions = this.baseReader.getDimensions(objectPath);
        int[] fullBlockDimensions = new int[fullDimensions.length];
        long[] fullOffset = new long[fullDimensions.length];
        int cardBoundIndices = MatrixUtils.cardinalityBoundIndices(boundIndices);
        MatrixUtils.checkBoundIndices(objectPath, fullDimensions, boundIndices);
        int[] effectiveBlockDimensions = new int[fullBlockDimensions.length - cardBoundIndices];
        Arrays.fill(effectiveBlockDimensions, -1);
        MatrixUtils.createFullBlockDimensionsAndOffset(effectiveBlockDimensions, null, boundIndices, fullDimensions, fullBlockDimensions, fullOffset);
        MDByteArray result = this.readMDArrayBlockWithOffset(objectPath, fullBlockDimensions, fullOffset);
        if (fullBlockDimensions.length == cardBoundIndices) {
            return new MDByteArray(result.getAsFlatArray(), new int[]{1});
        }
        return new MDByteArray(result.getAsFlatArray(), effectiveBlockDimensions);
    }

    @Override
    public MDByteArray readMDArray(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDByteArray> readCallable = new ICallableWithCleanUp<MDByteArray>(){

            @Override
            public MDByteArray call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5ByteReader)HDF5ByteReader.this).baseReader.h5.openDataSet(((HDF5ByteReader)HDF5ByteReader.this).baseReader.fileId, objectPath, registry);
                return HDF5ByteReader.this.readByteMDArray(dataSetId, registry);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    MDByteArray readByteMDArray(int dataSetId, ICleanUpRegistry registry) {
        try {
            HDF5BaseReader.DataSpaceParameters spaceParams = this.baseReader.getSpaceParameters(dataSetId, registry);
            byte[] data = new byte[spaceParams.blockSize];
            this.baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT8, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
            return new MDByteArray(data, spaceParams.dimensions);
        }
        catch (HDF5LibraryException ex) {
            int dataTypeId;
            if (ex.getMajorErrorNumber() == HDF5Constants.H5E_DATATYPE && ex.getMinorErrorNumber() == HDF5Constants.H5E_CANTINIT && this.baseReader.h5.getClassType(dataTypeId = this.baseReader.h5.getDataTypeForDataSet(dataSetId, registry)) == HDF5Constants.H5T_ARRAY) {
                return this.readByteMDArrayFromArrayType(dataSetId, dataTypeId, registry);
            }
            throw ex;
        }
    }

    private MDByteArray readByteMDArrayFromArrayType(int dataSetId, int dataTypeId, ICleanUpRegistry registry) {
        int[] arrayDimensions = this.baseReader.h5.getArrayDimensions(dataTypeId);
        int memoryDataTypeId = this.baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT8, arrayDimensions, registry);
        HDF5BaseReader.DataSpaceParameters spaceParams = this.baseReader.getSpaceParameters(dataSetId, registry);
        if (spaceParams.blockSize == 0) {
            int spaceId = this.baseReader.h5.createScalarDataSpace();
            byte[] data = new byte[MDArray.getLength(arrayDimensions)];
            this.baseReader.h5.readDataSet(dataSetId, memoryDataTypeId, spaceId, spaceId, data);
            return new MDByteArray(data, arrayDimensions);
        }
        byte[] data = new byte[MDArray.getLength(arrayDimensions) * spaceParams.blockSize];
        this.baseReader.h5.readDataSet(dataSetId, memoryDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
        return new MDByteArray(data, MatrixUtils.concat(MDArray.toInt(spaceParams.dimensions), arrayDimensions));
    }

    @Override
    public MDByteArray readSlicedMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber, IndexMap boundIndices) {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * (long)blockDimensions[i];
            ++i;
        }
        return this.readSlicedMDArrayBlockWithOffset(objectPath, blockDimensions, offset, boundIndices);
    }

    @Override
    public MDByteArray readSlicedMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber, long[] boundIndices) {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * (long)blockDimensions[i];
            ++i;
        }
        return this.readSlicedMDArrayBlockWithOffset(objectPath, blockDimensions, offset, boundIndices);
    }

    @Override
    public MDByteArray readMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * (long)blockDimensions[i];
            ++i;
        }
        return this.readMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public MDByteArray readSlicedMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset, IndexMap boundIndices) {
        this.baseReader.checkOpen();
        int[] effectiveBlockDimensions = (int[])blockDimensions.clone();
        long[] fullDimensions = this.baseReader.getDimensions(objectPath);
        int[] fullBlockDimensions = new int[fullDimensions.length];
        long[] fullOffset = new long[fullDimensions.length];
        MatrixUtils.checkBoundIndices(objectPath, fullDimensions, blockDimensions, MatrixUtils.cardinalityBoundIndices(boundIndices));
        MatrixUtils.createFullBlockDimensionsAndOffset(effectiveBlockDimensions, offset, (Map<Integer, Long>)boundIndices, fullDimensions, fullBlockDimensions, fullOffset);
        MDByteArray result = this.readMDArrayBlockWithOffset(objectPath, fullBlockDimensions, fullOffset);
        return new MDByteArray(result.getAsFlatArray(), effectiveBlockDimensions);
    }

    @Override
    public MDByteArray readSlicedMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset, long[] boundIndices) {
        this.baseReader.checkOpen();
        int[] effectiveBlockDimensions = (int[])blockDimensions.clone();
        long[] fullDimensions = this.baseReader.getDimensions(objectPath);
        int[] fullBlockDimensions = new int[fullDimensions.length];
        long[] fullOffset = new long[fullDimensions.length];
        MatrixUtils.checkBoundIndices(objectPath, fullDimensions, blockDimensions, MatrixUtils.cardinalityBoundIndices(boundIndices));
        MatrixUtils.createFullBlockDimensionsAndOffset(effectiveBlockDimensions, offset, boundIndices, fullDimensions, fullBlockDimensions, fullOffset);
        MDByteArray result = this.readMDArrayBlockWithOffset(objectPath, fullBlockDimensions, fullOffset);
        return new MDByteArray(result.getAsFlatArray(), effectiveBlockDimensions);
    }

    @Override
    public MDByteArray readMDArrayBlockWithOffset(final String objectPath, final int[] blockDimensions, final long[] offset) {
        assert (objectPath != null);
        assert (blockDimensions != null);
        assert (offset != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDByteArray> readCallable = new ICallableWithCleanUp<MDByteArray>(){

            @Override
            public MDByteArray call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5ByteReader)HDF5ByteReader.this).baseReader.h5.openDataSet(((HDF5ByteReader)HDF5ByteReader.this).baseReader.fileId, objectPath, registry);
                try {
                    HDF5BaseReader.DataSpaceParameters spaceParams = HDF5ByteReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockDimensions, registry);
                    byte[] dataBlock = new byte[spaceParams.blockSize];
                    ((HDF5ByteReader)HDF5ByteReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT8, spaceParams.memorySpaceId, spaceParams.dataSpaceId, dataBlock);
                    return new MDByteArray(dataBlock, spaceParams.dimensions);
                }
                catch (HDF5SpaceRankMismatch ex) {
                    HDF5DataSetInformation info = HDF5ByteReader.this.baseReader.getDataSetInformation(objectPath, HDF5DataTypeInformation.DataTypeInfoOptions.MINIMAL, false);
                    if (ex.getSpaceRankExpected() - ex.getSpaceRankFound() == info.getTypeInformation().getRank()) {
                        return HDF5ByteReader.this.readMDArrayBlockOfArrays(dataSetId, blockDimensions, offset, info, ex.getSpaceRankFound(), registry);
                    }
                    throw ex;
                }
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    private MDByteArray readMDArrayBlockOfArrays(int dataSetId, int[] blockDimensions, long[] offset, HDF5DataSetInformation info, int spaceRank, ICleanUpRegistry registry) {
        int[] arrayDimensions = info.getTypeInformation().getDimensions();
        int[] effectiveBlockDimensions = blockDimensions;
        int i = 0;
        while (i < arrayDimensions.length) {
            int j = spaceRank + i;
            if (effectiveBlockDimensions[j] < 0) {
                if (effectiveBlockDimensions == blockDimensions) {
                    effectiveBlockDimensions = (int[])blockDimensions.clone();
                }
                effectiveBlockDimensions[j] = arrayDimensions[i];
            }
            if (effectiveBlockDimensions[j] != arrayDimensions[i]) {
                throw new HDF5JavaException("Block-wise reading of array type data sets is not supported.");
            }
            ++i;
        }
        int[] spaceBlockDimensions = Arrays.copyOfRange(effectiveBlockDimensions, 0, spaceRank);
        long[] spaceOfs = Arrays.copyOfRange(offset, 0, spaceRank);
        HDF5BaseReader.DataSpaceParameters spaceParams = this.baseReader.getSpaceParameters(dataSetId, spaceOfs, spaceBlockDimensions, registry);
        byte[] dataBlock = new byte[spaceParams.blockSize * info.getTypeInformation().getNumberOfElements()];
        int memoryDataTypeId = this.baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT8, info.getTypeInformation().getDimensions(), registry);
        this.baseReader.h5.readDataSet(dataSetId, memoryDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, dataBlock);
        return new MDByteArray(dataBlock, effectiveBlockDimensions);
    }

    @Override
    public Iterable<HDF5DataBlock<byte[]>> getArrayNaturalBlocks(final String dataSetPath) throws HDF5JavaException {
        this.baseReader.checkOpen();
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5DataBlock<byte[]>>(){

            @Override
            public Iterator<HDF5DataBlock<byte[]>> iterator() {
                return new Iterator<HDF5DataBlock<byte[]>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<byte[]> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        byte[] block = HDF5ByteReader.this.readArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5DataBlock<byte[]>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDByteArray>> getMDArrayNaturalBlocks(final String dataSetPath) {
        this.baseReader.checkOpen();
        final HDF5NaturalBlockMDParameters params = new HDF5NaturalBlockMDParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5MDDataBlock<MDByteArray>>(){

            @Override
            public Iterator<HDF5MDDataBlock<MDByteArray>> iterator() {
                return new Iterator<HDF5MDDataBlock<MDByteArray>>(params){
                    final HDF5NaturalBlockMDParameters.HDF5NaturalBlockMDIndex index;
                    {
                        this.index = hDF5NaturalBlockMDParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5MDDataBlock<MDByteArray> next() {
                        long[] offset = this.index.computeOffsetAndSizeGetOffsetClone();
                        MDByteArray data = HDF5ByteReader.this.readMDArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5MDDataBlock<MDByteArray>(data, this.index.getIndexClone(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    byte[] getByteArrayAttribute(int objectId, String attributeName, ICleanUpRegistry registry) {
        int memoryTypeId;
        int len;
        Object[] arrayDimensions;
        int attributeId = this.baseReader.h5.openAttribute(objectId, attributeName, registry);
        int attributeTypeId = this.baseReader.h5.getDataTypeForAttribute(attributeId, registry);
        if (this.baseReader.h5.getClassType(attributeTypeId) == HDF5Constants.H5T_ARRAY) {
            arrayDimensions = this.baseReader.h5.getArrayDimensions(attributeTypeId);
            if (arrayDimensions.length != 1) {
                throw new HDF5JavaException("Array needs to be of rank 1, but is of rank " + arrayDimensions.length);
            }
            len = arrayDimensions[0];
            memoryTypeId = this.baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT8, len, registry);
        } else {
            arrayDimensions = this.baseReader.h5.getDataDimensionsForAttribute(attributeId, registry);
            memoryTypeId = HDF5Constants.H5T_NATIVE_INT8;
            len = HDF5Utils.getOneDimensionalArraySize((long[])arrayDimensions);
        }
        byte[] data = this.baseReader.h5.readAttributeAsByteArray(attributeId, memoryTypeId, len);
        return data;
    }

    MDByteArray getByteMDArrayAttribute(int objectId, String attributeName, ICleanUpRegistry registry) {
        try {
            int memoryTypeId;
            int[] arrayDimensions;
            int attributeId = this.baseReader.h5.openAttribute(objectId, attributeName, registry);
            int attributeTypeId = this.baseReader.h5.getDataTypeForAttribute(attributeId, registry);
            if (this.baseReader.h5.getClassType(attributeTypeId) == HDF5Constants.H5T_ARRAY) {
                arrayDimensions = this.baseReader.h5.getArrayDimensions(attributeTypeId);
                memoryTypeId = this.baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT8, arrayDimensions, registry);
            } else {
                arrayDimensions = MDArray.toInt(this.baseReader.h5.getDataDimensionsForAttribute(attributeId, registry));
                memoryTypeId = HDF5Constants.H5T_NATIVE_INT8;
            }
            int len = MDArray.getLength(arrayDimensions);
            byte[] data = this.baseReader.h5.readAttributeAsByteArray(attributeId, memoryTypeId, len);
            return new MDByteArray(data, arrayDimensions);
        }
        catch (IllegalArgumentException ex) {
            throw new HDF5JavaException(ex.getMessage());
        }
    }
}

