/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.table;

import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.table.LineDataTable;
import jhi.flapjack.gui.table.LineDataTableModel;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.undo.SelectedLinesState;
import scri.commons.gui.Icons;
import scri.commons.gui.RB;

public class LineDataTableMenu {
    private LineDataTable table;

    LineDataTableMenu(LineDataTable table) {
        this.table = table;
    }

    public JPopupMenu getFilterMenu() {
        JPopupMenu menu = new JPopupMenu();
        this.createFilterMenu(menu);
        return menu;
    }

    private void createFilterMenu(JComponent menu) {
        JMenuItem mFilter = new JMenuItem("Filter...");
        mFilter.setIcon(Icons.getIcon((String)"FILTER"));
        mFilter.addActionListener(e -> this.table.filterDialog());
        JMenuItem reset = new JMenuItem("Reset filters");
        reset.addActionListener(e -> this.table.resetFilters());
        menu.add(mFilter);
        menu.add(reset);
    }

    public JPopupMenu getSelectMenu() {
        JPopupMenu menu = new JPopupMenu();
        this.createSelectMenu(menu, false);
        return menu;
    }

    private void setLineStates(Boolean state) {
        GenotypePanel gPanel = Flapjack.winMain.getGenotypePanel();
        SelectedLinesState undo = new SelectedLinesState(gPanel.getView(), "selected lines");
        undo.createUndoState();
        LineDataTableModel model = this.table.getLineDataTableModel();
        model.setLineStates(state, true);
        undo.createRedoState();
        gPanel.addUndoState(undo);
        Flapjack.winMain.mEdit.editMode(2);
    }

    private void createSelectMenu(JComponent menu, boolean allOptions) {
        JMenuItem mSelect = new JMenuItem();
        mSelect.setText("Auto select...");
        mSelect.setIcon(Icons.getIcon((String)"AUTOSELECT"));
        mSelect.addActionListener(event -> this.table.selectDialog());
        JMenuItem mSelectAll = new JMenuItem();
        mSelectAll.setText("Select all");
        mSelectAll.addActionListener(event -> this.setLineStates(true));
        JMenuItem mSelectNone = new JMenuItem();
        mSelectNone.setText("Select none");
        mSelectNone.addActionListener(event -> this.setLineStates(false));
        JMenuItem mSelectInvert = new JMenuItem();
        mSelectInvert.setIcon(Icons.getIcon((String)"INVERT"));
        mSelectInvert.setText("Invert selection");
        mSelectInvert.addActionListener(event -> this.setLineStates(null));
        boolean enabled = this.table.getSelectionModel().getMinSelectionIndex() != -1;
        JMenuItem mSelectHighlightedAll = new JMenuItem();
        mSelectHighlightedAll.setText("Select highlighted");
        mSelectHighlightedAll.addActionListener(event -> this.table.selectHighlighted(true));
        mSelectHighlightedAll.setEnabled(enabled);
        JMenuItem mSelectHighlightedNone = new JMenuItem();
        mSelectHighlightedNone.setText("Deselect highlighted");
        mSelectHighlightedNone.addActionListener(event -> this.table.selectHighlighted(false));
        mSelectHighlightedNone.setEnabled(enabled);
        JMenuItem mSelectHighlightedInvert = new JMenuItem();
        mSelectHighlightedInvert.setText("Invert highlighted");
        mSelectHighlightedInvert.addActionListener(event -> this.table.selectHighlighted(null));
        mSelectHighlightedInvert.setEnabled(enabled);
        menu.add(mSelect);
        if (menu instanceof JMenu) {
            ((JMenu)menu).addSeparator();
        } else {
            ((JPopupMenu)menu).addSeparator();
        }
        menu.add(mSelectAll);
        menu.add(mSelectNone);
        menu.add(mSelectInvert);
        if (allOptions) {
            if (menu instanceof JMenu) {
                ((JMenu)menu).addSeparator();
            } else {
                ((JPopupMenu)menu).addSeparator();
            }
            menu.add(mSelectHighlightedAll);
            menu.add(mSelectHighlightedNone);
            menu.add(mSelectHighlightedInvert);
        }
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenu menuFilter = new JMenu();
        menuFilter.setText("Filter");
        this.createFilterMenu(menuFilter);
        JMenu menuSelect = new JMenu();
        menuSelect.setText("Select");
        this.createSelectMenu(menuSelect, true);
        JMenuItem mCopy = new JMenuItem();
        mCopy.setText(RB.getString((String)"gui.mabc.MabcPanel.copy"));
        mCopy.setIcon(Icons.getIcon((String)"COPY"));
        mCopy.addActionListener(e -> this.table.copyTableToClipboard());
        JMenuItem mSort = new JMenuItem();
        mSort.setText("Sort...");
        mSort.setIcon(Icons.getIcon((String)"SORT"));
        mSort.addActionListener(e -> this.table.sortDialog());
        JMenuItem mExport = new JMenuItem();
        mExport.setText(RB.getString((String)"gui.mabc.MabcPanel.export"));
        mExport.setIcon(Icons.getIcon((String)"EXPORTTRAITS"));
        mExport.addActionListener(e -> this.table.exportData());
        menu.add(menuSelect);
        menu.add(mCopy);
        menu.addSeparator();
        menu.add(menuFilter);
        menu.add(mSort);
        menu.add(mExport);
        return menu;
    }
}

