/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.analysis;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.gui.dialog.analysis.SortLinesDialog;
import scri.commons.gui.RB;
import scri.commons.gui.matisse.HyperLinkLabel;

class SortLinesPanelNB
extends JPanel
implements ActionListener {
    private GTView view;
    private ButtonGroup group1;
    private ButtonGroup group2;
    private JScrollPane jScrollPane1;
    private JLabel label2;
    private JLabel lineLabel;
    private JPanel linePanel;
    private HyperLinkLabel selectAllLabel;
    private HyperLinkLabel selectNoneLabel;
    JComboBox<LineInfo> selectedLine;
    private JTable table;
    private JLabel tableLabel;
    private JPanel tablePanel;

    public SortLinesPanelNB(SortLinesDialog dialog, GTViewSet viewSet) {
        this.initComponents();
        this.setBackground((Color)UIManager.get("fjDialogBG"));
        this.linePanel.setBackground((Color)UIManager.get("fjDialogBG"));
        this.tablePanel.setBackground((Color)UIManager.get("fjDialogBG"));
        this.linePanel.setBorder(BorderFactory.createTitledBorder(RB.getString((String)"gui.dialog.analysis.NBSortLinesPanel.linePanel.title")));
        this.tablePanel.setBorder(BorderFactory.createTitledBorder(RB.getString((String)"gui.dialog.analysis.NBSortLinesPanel.tablePanel.title")));
        RB.setText((JLabel)this.tableLabel, (String)"gui.dialog.analysis.NBSortLinesPanel.tableLabel");
        RB.setText((JLabel)this.selectAllLabel, (String)"gui.dialog.analysis.NBSortLinesPanel.selectAllLabel");
        RB.setText((JLabel)this.selectNoneLabel, (String)"gui.dialog.analysis.NBSortLinesPanel.selectNoneLabel");
        RB.setText((JLabel)this.lineLabel, (String)"gui.dialog.analysis.NBSortLinesPanel.lineLabel.similarity");
        this.view = viewSet.getView(viewSet.getViewIndex());
        DefaultComboBoxModel<LineInfo> lineModel = new DefaultComboBoxModel<LineInfo>();
        for (int i = 0; i < this.view.lineCount(); ++i) {
            lineModel.addElement(this.view.getLineInfo(i));
        }
        this.selectedLine.setModel(lineModel);
        if (this.view.mouseOverLine >= 0 && this.view.mouseOverLine < this.view.lineCount()) {
            this.selectedLine.setSelectedIndex(this.view.mouseOverLine);
        }
        this.selectedLine.addActionListener(dialog);
        this.selectAllLabel.addActionListener((ActionListener)this);
        this.selectNoneLabel.addActionListener((ActionListener)this);
        this.createTable(viewSet);
    }

    private void createTable(GTViewSet viewSet) {
        Object[] columnNames = new String[]{RB.getString((String)"gui.dialog.analysis.NBSortLinesPanel.column1"), RB.getString((String)"gui.dialog.analysis.NBSortLinesPanel.column2"), RB.getString((String)"gui.dialog.analysis.NBSortLinesPanel.column3")};
        Object[][] data = new Object[viewSet.chromosomeCount()][3];
        for (int i = 0; i < viewSet.chromosomeCount(); ++i) {
            GTView view = viewSet.getView(i);
            data[i][0] = viewSet.getViewIndex() == i ? Boolean.valueOf(true) : Boolean.valueOf(false);
            data[i][1] = view.getChromosomeMap().getName();
            data[i][2] = view.countSelectedMarkers() + " / " + view.markerCount();
        }
        this.table.setModel(new DefaultTableModel(data, columnNames){

            public Class getColumnClass(int c) {
                return this.getValueAt(0, c).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 0;
            }
        });
        DefaultTableCellRenderer cr = new DefaultTableCellRenderer();
        cr.setHorizontalAlignment(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.table.setDefaultRenderer(String.class, cr);
        Rectangle r = this.table.getCellRect(viewSet.getViewIndex(), 0, true);
        this.table.scrollRectToVisible(r);
    }

    boolean[] getSelectedChromosomes() {
        boolean[] array = new boolean[this.table.getRowCount()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Boolean)this.table.getValueAt(i, 0);
        }
        return array;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        if (e.getSource() == this.selectAllLabel) {
            for (i = 0; i < this.table.getRowCount(); ++i) {
                this.table.setValueAt(true, i, 0);
            }
        }
        if (e.getSource() == this.selectNoneLabel) {
            for (i = 0; i < this.table.getRowCount(); ++i) {
                this.table.setValueAt(false, i, 0);
            }
        }
    }

    private void initComponents() {
        this.group1 = new ButtonGroup();
        this.group2 = new ButtonGroup();
        this.tablePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.tableLabel = new JLabel();
        this.label2 = new JLabel();
        this.selectAllLabel = new HyperLinkLabel();
        this.selectNoneLabel = new HyperLinkLabel();
        this.linePanel = new JPanel();
        this.selectedLine = new JComboBox();
        this.lineLabel = new JLabel();
        this.tablePanel.setBorder(BorderFactory.createTitledBorder("Sort over chromosomes:"));
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.table.setRowSelectionAllowed(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.table);
        this.tableLabel.setLabelFor(this.table);
        this.tableLabel.setText("Only markers from the following selected chromosomes will be used:");
        this.label2.setText("|");
        this.selectAllLabel.setText("Select all");
        this.selectNoneLabel.setText("Select none");
        GroupLayout tablePanelLayout = new GroupLayout(this.tablePanel);
        this.tablePanel.setLayout(tablePanelLayout);
        tablePanelLayout.setHorizontalGroup(tablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tablePanelLayout.createSequentialGroup().addContainerGap().addGroup(tablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addComponent(this.tableLabel, -1, -1, Short.MAX_VALUE).addGroup(tablePanelLayout.createSequentialGroup().addComponent((Component)this.selectAllLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.label2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.selectNoneLabel, -2, -1, -2))).addContainerGap()));
        tablePanelLayout.setVerticalGroup(tablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tablePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tableLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 153, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tablePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label2).addComponent((Component)this.selectAllLabel, -2, -1, -2).addComponent((Component)this.selectNoneLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.linePanel.setBorder(BorderFactory.createTitledBorder("Comparison line:"));
        this.lineLabel.setLabelFor(this.selectedLine);
        this.lineLabel.setText("Sort {0} to this line:");
        GroupLayout linePanelLayout = new GroupLayout(this.linePanel);
        this.linePanel.setLayout(linePanelLayout);
        linePanelLayout.setHorizontalGroup(linePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(linePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lineLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectedLine, 0, -1, Short.MAX_VALUE).addContainerGap()));
        linePanelLayout.setVerticalGroup(linePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(linePanelLayout.createSequentialGroup().addContainerGap().addGroup(linePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lineLabel).addComponent(this.selectedLine, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tablePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.linePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.linePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }
}

