/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.analysis;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import jhi.flapjack.analysis.AnalysisSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.pedigree.PedManager;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.dialog.analysis.ChromosomeSelectionDialog;
import scri.commons.gui.ITrackableJob;
import scri.commons.gui.ProgressDialog;
import scri.commons.gui.RB;
import scri.commons.gui.SimpleJob;
import scri.commons.gui.TaskDialog;
import scri.commons.gui.matisse.DialogPanel;
import scri.commons.gui.matisse.HyperLinkLabel;

public class MABCStatsDialog
extends JDialog
implements ActionListener {
    private GTViewSet viewSet;
    private ChromosomeSelectionDialog csd;
    private AnalysisSet as;
    private DefaultComboBoxModel<LineInfo> rpModel;
    private DefaultComboBoxModel<LineInfo> dpModel;
    private boolean isOK;
    private JButton bCancel;
    private JButton bHelp;
    private JButton bOK;
    private JRadioButton bUnweighted;
    private JRadioButton bWeighted;
    private JCheckBox chkExcludeParents;
    private HyperLinkLabel csdLabel;
    private JPanel dataPanel;
    private DialogPanel dialogPanel1;
    private JComboBox<LineInfo> donorCombo;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel lblParent1;
    private JLabel lblParent2;
    private JSpinner maxMrkrCoverage;
    private JComboBox<LineInfo> recurrentCombo;
    private JPanel settingsPanel;

    public MABCStatsDialog(GTViewSet viewSet) {
        super(Flapjack.winMain, RB.getString((String)"gui.dialog.analysis.MABCStatsDialog.title"), true);
        this.viewSet = viewSet;
        this.isOK = false;
        this.as = new AnalysisSet(this.viewSet).withViews(null).withSelectedLines().withSelectedMarkers();
        this.initComponents();
        this.initComponents2();
        FlapjackUtils.initDialog(this, this.bOK, this.bCancel, true, this.getContentPane(), this.settingsPanel, this.dataPanel);
    }

    private void initComponents2() {
        this.maxMrkrCoverage.setValue(Prefs.mabcMaxMrkrCoverage);
        this.bOK.addActionListener(this);
        RB.setText((AbstractButton)this.bCancel, (String)"gui.text.cancel");
        this.bCancel.addActionListener(this);
        RB.setText((AbstractButton)this.bHelp, (String)"gui.text.help");
        FlapjackUtils.setHelp(this.bHelp, "mabc.html");
        RB.setText((AbstractButton)this.chkExcludeParents, (String)"gui.dialog.analysis.MABCStatsDialog.chkExlcudeParents");
        this.chkExcludeParents.addActionListener(this);
        this.chkExcludeParents.setSelected(Prefs.guiMabcExcludeParents);
        this.csd = new ChromosomeSelectionDialog(this.viewSet, true);
        this.csdLabel.addActionListener(e -> this.csd.setVisible(true));
        this.setupComboBoxes(this.as);
        ButtonGroup bGroup = new ButtonGroup();
        bGroup.add(this.bWeighted);
        bGroup.add(this.bUnweighted);
        this.bWeighted.addActionListener(this);
        this.bUnweighted.addActionListener(this);
        this.bWeighted.setSelected(!Prefs.guiUseSimpleMabcStats);
        this.bUnweighted.setSelected(Prefs.guiUseSimpleMabcStats);
        this.jLabel3.setEnabled(!Prefs.guiUseSimpleMabcStats);
        this.maxMrkrCoverage.setEnabled(!Prefs.guiUseSimpleMabcStats);
        if (this.viewSet.getView(0).countSelectedLines() < 2) {
            this.bOK.setEnabled(false);
        }
    }

    private void setupComboBoxes(AnalysisSet as) {
        this.createRPComboModelFrom(as);
        this.recurrentCombo.setModel(this.rpModel);
        this.createDPComboModelFrom(as);
        this.donorCombo.setModel(this.dpModel);
        PedManager pm = this.viewSet.getDataSet().getPedManager();
        if (pm.getPedigrees().size() > 0 && (this.rpModel.getSize() > 1 || this.dpModel.getSize() > 1)) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    ParentSelector selector = new ParentSelector();
                    ProgressDialog dialog = new ProgressDialog((ITrackableJob)selector, RB.getString((String)"gui.dialog.analysis.MABCStatsDialog.parentSelectorProgress.title"), RB.getString((String)"gui.dialog.analysis.MABCStatsDialog.parentSelectorProgress.label"), (Frame)Flapjack.winMain);
                    TaskDialog.warning((String)RB.getString((String)"gui.dialog.analysis.MABCStatsDialog.rpdpWarning"), (String)RB.getString((String)"gui.text.close"));
                }
            });
        }
        if (pm.getPedigrees().size() == 0) {
            if (this.rpModel.getSize() >= 1) {
                this.recurrentCombo.setSelectedIndex(0);
            }
            if (this.dpModel.getSize() >= 2) {
                this.donorCombo.setSelectedIndex(1);
            }
        }
    }

    private void createRPComboModelFrom(AnalysisSet as) {
        int i;
        PedManager pm = this.viewSet.getDataSet().getPedManager();
        this.rpModel = new DefaultComboBoxModel();
        for (i = 0; i < as.lineCount(); ++i) {
            if (!pm.isRP(as.getLine(i))) continue;
            this.rpModel.addElement(as.getLine(i));
        }
        if (this.rpModel.getSize() == 0) {
            for (i = 0; i < as.lineCount(); ++i) {
                this.rpModel.addElement(as.getLine(i));
            }
        }
    }

    private void createDPComboModelFrom(AnalysisSet as) {
        int i;
        PedManager pm = this.viewSet.getDataSet().getPedManager();
        this.dpModel = new DefaultComboBoxModel();
        for (i = 0; i < as.lineCount(); ++i) {
            if (!pm.isDP(as.getLine(i))) continue;
            this.dpModel.addElement(as.getLine(i));
        }
        if (this.dpModel.getSize() == 0) {
            for (i = 0; i < as.lineCount(); ++i) {
                this.dpModel.addElement(as.getLine(i));
            }
        }
    }

    public boolean[] getSelectedChromosomes() {
        return this.csd.getSelectedChromosomes();
    }

    public int getRecurrentParent() {
        LineInfo rpInfo = (LineInfo)this.recurrentCombo.getSelectedItem();
        return this.as.getLines().indexOf(rpInfo);
    }

    public int getDonorParent() {
        LineInfo dpInfo = (LineInfo)this.donorCombo.getSelectedItem();
        return this.as.getLines().indexOf(dpInfo);
    }

    public boolean isOK() {
        return this.isOK;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bOK) {
            Prefs.mabcMaxMrkrCoverage = (Double)this.maxMrkrCoverage.getValue();
            this.isOK = true;
            this.setVisible(false);
        } else if (e.getSource() == this.bCancel) {
            this.setVisible(false);
        } else if (e.getSource() == this.bWeighted) {
            this.jLabel3.setEnabled(true);
            this.maxMrkrCoverage.setEnabled(true);
            Prefs.guiUseSimpleMabcStats = this.bUnweighted.isSelected();
        } else if (e.getSource() == this.bUnweighted) {
            this.jLabel3.setEnabled(false);
            this.maxMrkrCoverage.setEnabled(false);
            Prefs.guiUseSimpleMabcStats = this.bUnweighted.isSelected();
        } else if (e.getSource() == this.chkExcludeParents) {
            Prefs.guiMabcExcludeParents = this.chkExcludeParents.isSelected();
        }
    }

    public boolean isSimpleStats() {
        return Prefs.guiUseSimpleMabcStats;
    }

    private void initComponents() {
        this.dialogPanel1 = new DialogPanel();
        this.bOK = new JButton();
        this.bCancel = new JButton();
        this.bHelp = new JButton();
        this.settingsPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.maxMrkrCoverage = new JSpinner();
        this.lblParent1 = new JLabel();
        this.recurrentCombo = new JComboBox();
        this.lblParent2 = new JLabel();
        this.donorCombo = new JComboBox();
        this.bWeighted = new JRadioButton();
        this.bUnweighted = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.chkExcludeParents = new JCheckBox();
        this.dataPanel = new JPanel();
        this.csdLabel = new HyperLinkLabel();
        this.setDefaultCloseOperation(2);
        this.bOK.setText("Run");
        this.dialogPanel1.add((Component)this.bOK);
        this.bCancel.setText("Cancel");
        this.dialogPanel1.add((Component)this.bCancel);
        this.bHelp.setText("Help");
        this.dialogPanel1.add((Component)this.bHelp);
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder("General settings:"));
        this.jLabel3.setText("Maximum coverage per marker (cM): ");
        this.maxMrkrCoverage.setModel(new SpinnerNumberModel((Number)10.0, Double.valueOf(0.0), null, (Number)0.25));
        this.lblParent1.setText("Select recurrent parent line:");
        this.lblParent1.setToolTipText("");
        this.lblParent2.setText("Select donor parent line:");
        this.lblParent2.setToolTipText("");
        this.bWeighted.setText("Weighted model");
        this.bUnweighted.setText("Unweighted model");
        this.jLabel1.setText("<html>Marker Assisted Back Crossing statistics will calculate Recurrent Parent Percentages<br>for each line across each chromosome, and will also display linkage drag and QTL<br>status information if appropriate.");
        this.chkExcludeParents.setText("Exclude other parental lines from analysis and view");
        GroupLayout settingsPanelLayout = new GroupLayout(this.settingsPanel);
        this.settingsPanel.setLayout(settingsPanelLayout);
        settingsPanelLayout.setHorizontalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(settingsPanelLayout.createSequentialGroup().addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblParent1).addComponent(this.lblParent2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.donorCombo, 0, -1, Short.MAX_VALUE).addComponent(this.recurrentCombo, 0, -1, Short.MAX_VALUE))).addGroup(settingsPanelLayout.createSequentialGroup().addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bWeighted).addComponent(this.bUnweighted).addGroup(settingsPanelLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxMrkrCoverage, -2, 91, -2)).addComponent(this.chkExcludeParents)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        settingsPanelLayout.setVerticalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, settingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addGap(18, 18, 18).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblParent1).addComponent(this.recurrentCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblParent2).addComponent(this.donorCombo, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.chkExcludeParents).addGap(18, 18, 18).addComponent(this.bWeighted).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.maxMrkrCoverage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bUnweighted).addContainerGap(-1, Short.MAX_VALUE)));
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Data selection settings:"));
        this.csdLabel.setText("Select chromosomes to analyse");
        GroupLayout dataPanelLayout = new GroupLayout(this.dataPanel);
        this.dataPanel.setLayout(dataPanelLayout);
        dataPanelLayout.setHorizontalGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataPanelLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.csdLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        dataPanelLayout.setVerticalGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataPanelLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.csdLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dialogPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.settingsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.dataPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.settingsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dialogPanel1, -2, 44, -2)));
        this.pack();
    }

    class ParentSelector
    extends SimpleJob {
        ParentSelector() {
        }

        public void runJob(int jobIndex) throws Exception {
            this.selectParents(MABCStatsDialog.this.rpModel);
            this.selectParents(MABCStatsDialog.this.dpModel);
        }

        void selectParents(DefaultComboBoxModel<LineInfo> model) {
            int maxMarkerCount = 0;
            LineInfo found = null;
            for (int i = 0; i < model.getSize(); ++i) {
                LineInfo lineInfo = model.getElementAt(i);
                int lineIndex = MABCStatsDialog.this.as.getLines().indexOf(lineInfo);
                int viewCount = MABCStatsDialog.this.as.viewCount();
                int markerCount = 0;
                for (int viewIndex = 0; viewIndex < viewCount; ++viewIndex) {
                    for (int markerIndex = 0; markerIndex < MABCStatsDialog.this.as.markerCount(viewIndex); ++markerIndex) {
                        if (MABCStatsDialog.this.as.getState(viewIndex, lineIndex, markerIndex) <= 0) continue;
                        ++markerCount;
                    }
                }
                if (markerCount <= maxMarkerCount) continue;
                maxMarkerCount = markerCount;
                found = lineInfo;
            }
            if (found != null) {
                model.setSelectedItem(found);
            }
        }
    }
}

